@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the runtime. Supported runtimes can be queried by data source alicloud_cs_kubernetes_version.
 * @property version The version of the runtime.
 * The following example is the definition of runtime block:
 * ```
 * runtime = {
 * name = "containerd"
 * version = "1.6.28"
 * }
 * ```
 */
public data class EdgeKubernetesRuntime(
    public val name: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.EdgeKubernetesRuntime): EdgeKubernetesRuntime = EdgeKubernetesRuntime(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
