@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoSnapshotPolicyId Worker node data disk auto snapshot policy.
 * @property category The type of the data disks. Valid values: `cloud`, `cloud_efficiency`, `cloud_ssd` and `cloud_essd`. Default to `cloud_efficiency`.
 * @property device The device of the data disks.
 * @property encrypted Specifies whether to encrypt data disks. Valid values: true and false. Default is `false`.
 * @property kmsKeyId The id of the kms key.
 * @property name The name of the data disks.
 * @property performanceLevel Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
 * @property size The size of a data disk, at least 40. Unit: GiB.
 * @property snapshotId The id of snapshot.
 */
public data class EdgeKubernetesWorkerDataDisk(
    public val autoSnapshotPolicyId: String? = null,
    public val category: String? = null,
    public val device: String? = null,
    public val encrypted: String? = null,
    public val kmsKeyId: String? = null,
    public val name: String? = null,
    public val performanceLevel: String? = null,
    public val size: String? = null,
    public val snapshotId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.EdgeKubernetesWorkerDataDisk): EdgeKubernetesWorkerDataDisk = EdgeKubernetesWorkerDataDisk(
            autoSnapshotPolicyId = javaType.autoSnapshotPolicyId().map({ args0 -> args0 }).orElse(null),
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            device = javaType.device().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            performanceLevel = javaType.performanceLevel().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
