@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id ID of the node.
 * @property name The kubernetes cluster's name. It is unique in one Alicloud account.
 * @property privateIp The private IP address of node.
 */
public data class EdgeKubernetesWorkerNode(
    public val id: String? = null,
    public val name: String? = null,
    public val privateIp: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.EdgeKubernetesWorkerNode): EdgeKubernetesWorkerNode = EdgeKubernetesWorkerNode(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            privateIp = javaType.privateIp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
