@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clientCert The base64 encoded client certificate data required to communicate with your cluster. Add this to the client-certificate-data section of the kube config file for your cluster.
 * @property clientKey The base64 encoded client key data required to communicate with your cluster. Add this to the client-key-data section of the kube config file for your cluster.
 * @property clusterCert The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kube config file for your cluster.
 */
public data class GetClusterCredentialCertificateAuthority(
    public val clientCert: String,
    public val clientKey: String,
    public val clusterCert: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetClusterCredentialCertificateAuthority): GetClusterCredentialCertificateAuthority = GetClusterCredentialCertificateAuthority(
            clientCert = javaType.clientCert(),
            clientKey = javaType.clientKey(),
            clusterCert = javaType.clusterCert(),
        )
    }
}
