@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getClusterCredential.
 * @property certificateAuthority (Available in 1.105.0+) Nested attribute containing certificate authority data for your cluster.
 * @property clusterId The id of target cluster.
 * @property clusterName The name of target cluster.
 * @property expiration Expiration time of kube config. Format: UTC time in rfc3339.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kubeConfig (Sensitive) The kube config to use to authenticate with the cluster.
 * @property outputFile
 * @property temporaryDurationMinutes
 */
public data class GetClusterCredentialResult(
    public val certificateAuthority: GetClusterCredentialCertificateAuthority,
    public val clusterId: String,
    public val clusterName: String,
    public val expiration: String,
    public val id: String,
    public val kubeConfig: String,
    public val outputFile: String? = null,
    public val temporaryDurationMinutes: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetClusterCredentialResult): GetClusterCredentialResult = GetClusterCredentialResult(
            certificateAuthority = javaType.certificateAuthority().let({ args0 ->
                com.pulumi.alicloud.cs.kotlin.outputs.GetClusterCredentialCertificateAuthority.Companion.toKotlin(args0)
            }),
            clusterId = javaType.clusterId(),
            clusterName = javaType.clusterName(),
            expiration = javaType.expiration(),
            id = javaType.id(),
            kubeConfig = javaType.kubeConfig(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            temporaryDurationMinutes = javaType.temporaryDurationMinutes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
