@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZone The ID of availability zone.
 * @property connections Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
 * @property id ID of the node.
 * @property name Node name.
 * @property natGatewayId The ID of nat gateway used to launch kubernetes cluster.
 * @property securityGroupId The ID of security group where the current cluster worker node is located.
 * @property vpcId The ID of VPC where the current cluster is located.
 * @property workerNodes List of cluster worker nodes. It contains several attributes to `Block Nodes`.
 */
public data class GetEdgeKubernetesClustersCluster(
    public val availabilityZone: String,
    public val connections: GetEdgeKubernetesClustersClusterConnections,
    public val id: String,
    public val name: String,
    public val natGatewayId: String,
    public val securityGroupId: String,
    public val vpcId: String,
    public val workerNodes: List<GetEdgeKubernetesClustersClusterWorkerNode>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetEdgeKubernetesClustersCluster): GetEdgeKubernetesClustersCluster = GetEdgeKubernetesClustersCluster(
            availabilityZone = javaType.availabilityZone(),
            connections = javaType.connections().let({ args0 ->
                com.pulumi.alicloud.cs.kotlin.outputs.GetEdgeKubernetesClustersClusterConnections.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            name = javaType.name(),
            natGatewayId = javaType.natGatewayId(),
            securityGroupId = javaType.securityGroupId(),
            vpcId = javaType.vpcId(),
            workerNodes = javaType.workerNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetEdgeKubernetesClustersClusterWorkerNode.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
