@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getKubernetesAddonMetadata.
 * @property clusterId
 * @property configSchema The addon configuration that can be customized. The returned format is the standard json schema. If return empty, it means that the addon does not support custom configuration yet.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property version
 */
public data class GetKubernetesAddonMetadataResult(
    public val clusterId: String,
    public val configSchema: String,
    public val id: String,
    public val name: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetKubernetesAddonMetadataResult): GetKubernetesAddonMetadataResult = GetKubernetesAddonMetadataResult(
            clusterId = javaType.clusterId(),
            configSchema = javaType.configSchema(),
            id = javaType.id(),
            name = javaType.name(),
            version = javaType.version(),
        )
    }
}
