@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property currentConfig The current custom configuration of the addon. **Note:** Available in v1.166.0+
 * @property currentVersion The current version of addon, if this field is an empty string, it means that the addon is not installed.
 * @property name The name of addon.
 * @property nextVersion The next version of this addon can be upgraded to.
 * @property required Whether the addon is a system addon.
 */
public data class GetKubernetesAddonsAddon(
    public val currentConfig: String,
    public val currentVersion: String,
    public val name: String,
    public val nextVersion: String,
    public val required: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetKubernetesAddonsAddon): GetKubernetesAddonsAddon = GetKubernetesAddonsAddon(
            currentConfig = javaType.currentConfig(),
            currentVersion = javaType.currentVersion(),
            name = javaType.name(),
            nextVersion = javaType.nextVersion(),
            required = javaType.required(),
        )
    }
}
