@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getKubernetesAddons.
 * @property addons A list of addons.
 * @property clusterId The id of kubernetes cluster.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of addon names.
 */
public data class GetKubernetesAddonsResult(
    public val addons: List<GetKubernetesAddonsAddon>,
    public val clusterId: String,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetKubernetesAddonsResult): GetKubernetesAddonsResult = GetKubernetesAddonsResult(
            addons = javaType.addons().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesAddonsAddon.Companion.toKotlin(args0)
                })
            }),
            clusterId = javaType.clusterId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
        )
    }
}
