@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZone The ID of availability zone.
 * @property clusterNetworkType
 * @property connections Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
 * @property id ID of the node.
 * @property imageId The ID of node image.
 * @property keyName The keypair of ssh login cluster node, you have to create it first.
 * @property logConfigs A list of one element containing information about the associated log store. It contains the following attributes:
 * @property masterAutoRenew
 * @property masterAutoRenewPeriod
 * @property masterDiskCategory The system disk category of master node.
 * @property masterDiskSize The system disk size of master node.
 * @property masterInstanceChargeType
 * @property masterInstanceTypes The instance type of master node.
 * @property masterNodes List of cluster master nodes. It contains several attributes to `Block Nodes`.
 * @property masterPeriod
 * @property masterPeriodUnit
 * @property name Node name.
 * @property natGatewayId The ID of nat gateway used to launch kubernetes cluster.
 * @property nodeCidrMask The network mask used on pods for each node.
 * @property podCidr
 * @property securityGroupId The ID of security group where the current cluster worker node is located.
 * @property serviceCidr
 * @property slbInternetEnabled Whether internet load balancer for API Server is created
 * @property vpcId The ID of VPC where the current cluster is located.
 * @property vswitchIds The ID of VSwitches where the current cluster is located.
 * @property workerAutoRenew
 * @property workerAutoRenewPeriod
 * @property workerDataDiskCategory The data disk size of worker node.
 * @property workerDataDiskSize The data disk category of worker node.
 * @property workerDiskCategory The system disk category of worker node.
 * @property workerDiskSize The system disk size of worker node.
 * @property workerInstanceChargeType
 * @property workerInstanceTypes The instance type of worker node.
 * @property workerNodes List of cluster worker nodes. It contains several attributes to `Block Nodes`.
 * @property workerNumbers The ECS instance node number in the current container cluster.
 * @property workerPeriod
 * @property workerPeriodUnit
 */
public data class GetKubernetesClustersCluster(
    public val availabilityZone: String,
    public val clusterNetworkType: String,
    public val connections: GetKubernetesClustersClusterConnections,
    public val id: String,
    public val imageId: String,
    public val keyName: String,
    public val logConfigs: List<GetKubernetesClustersClusterLogConfig>,
    public val masterAutoRenew: Boolean,
    public val masterAutoRenewPeriod: Int,
    public val masterDiskCategory: String,
    public val masterDiskSize: Int,
    public val masterInstanceChargeType: String,
    public val masterInstanceTypes: List<String>,
    public val masterNodes: List<GetKubernetesClustersClusterMasterNode>,
    public val masterPeriod: Int,
    public val masterPeriodUnit: String,
    public val name: String,
    public val natGatewayId: String,
    public val nodeCidrMask: Int,
    public val podCidr: String,
    public val securityGroupId: String,
    public val serviceCidr: String,
    public val slbInternetEnabled: Boolean,
    public val vpcId: String,
    public val vswitchIds: List<String>,
    public val workerAutoRenew: Boolean,
    public val workerAutoRenewPeriod: Int,
    public val workerDataDiskCategory: String,
    public val workerDataDiskSize: Int,
    public val workerDiskCategory: String,
    public val workerDiskSize: Int,
    public val workerInstanceChargeType: String,
    public val workerInstanceTypes: List<String>,
    public val workerNodes: List<GetKubernetesClustersClusterWorkerNode>,
    public val workerNumbers: List<Int>,
    public val workerPeriod: Int,
    public val workerPeriodUnit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetKubernetesClustersCluster): GetKubernetesClustersCluster = GetKubernetesClustersCluster(
            availabilityZone = javaType.availabilityZone(),
            clusterNetworkType = javaType.clusterNetworkType(),
            connections = javaType.connections().let({ args0 ->
                com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesClustersClusterConnections.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            imageId = javaType.imageId(),
            keyName = javaType.keyName(),
            logConfigs = javaType.logConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesClustersClusterLogConfig.Companion.toKotlin(args0)
                })
            }),
            masterAutoRenew = javaType.masterAutoRenew(),
            masterAutoRenewPeriod = javaType.masterAutoRenewPeriod(),
            masterDiskCategory = javaType.masterDiskCategory(),
            masterDiskSize = javaType.masterDiskSize(),
            masterInstanceChargeType = javaType.masterInstanceChargeType(),
            masterInstanceTypes = javaType.masterInstanceTypes().map({ args0 -> args0 }),
            masterNodes = javaType.masterNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesClustersClusterMasterNode.Companion.toKotlin(args0)
                })
            }),
            masterPeriod = javaType.masterPeriod(),
            masterPeriodUnit = javaType.masterPeriodUnit(),
            name = javaType.name(),
            natGatewayId = javaType.natGatewayId(),
            nodeCidrMask = javaType.nodeCidrMask(),
            podCidr = javaType.podCidr(),
            securityGroupId = javaType.securityGroupId(),
            serviceCidr = javaType.serviceCidr(),
            slbInternetEnabled = javaType.slbInternetEnabled(),
            vpcId = javaType.vpcId(),
            vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
            workerAutoRenew = javaType.workerAutoRenew(),
            workerAutoRenewPeriod = javaType.workerAutoRenewPeriod(),
            workerDataDiskCategory = javaType.workerDataDiskCategory(),
            workerDataDiskSize = javaType.workerDataDiskSize(),
            workerDiskCategory = javaType.workerDiskCategory(),
            workerDiskSize = javaType.workerDiskSize(),
            workerInstanceChargeType = javaType.workerInstanceChargeType(),
            workerInstanceTypes = javaType.workerInstanceTypes().map({ args0 -> args0 }),
            workerNodes = javaType.workerNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesClustersClusterWorkerNode.Companion.toKotlin(args0)
                })
            }),
            workerNumbers = javaType.workerNumbers().map({ args0 -> args0 }),
            workerPeriod = javaType.workerPeriod(),
            workerPeriodUnit = javaType.workerPeriodUnit(),
        )
    }
}
