@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiServerInternet API Server Internet endpoint.
 * @property apiServerIntranet API Server Intranet endpoint.
 * @property masterPublicIp Master node SSH IP address.
 * @property serviceDomain Service Access Domain.
 */
public data class GetKubernetesClustersClusterConnections(
    public val apiServerInternet: String,
    public val apiServerIntranet: String,
    public val masterPublicIp: String,
    public val serviceDomain: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetKubernetesClustersClusterConnections): GetKubernetesClustersClusterConnections = GetKubernetesClustersClusterConnections(
            apiServerInternet = javaType.apiServerInternet(),
            apiServerIntranet = javaType.apiServerIntranet(),
            masterPublicIp = javaType.masterPublicIp(),
            serviceDomain = javaType.serviceDomain(),
        )
    }
}
