@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getKubernetesClusters.
 * @property clusters A list of matched Kubernetes clusters. Each element contains the following attributes:
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of matched Kubernetes clusters' ids.
 * @property kubeConfigFilePrefix
 * @property nameRegex
 * @property names A list of matched Kubernetes clusters' names.
 * @property outputFile
 */
public data class GetKubernetesClustersResult(
    public val clusters: List<GetKubernetesClustersCluster>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val kubeConfigFilePrefix: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetKubernetesClustersResult): GetKubernetesClustersResult = GetKubernetesClustersResult(
            clusters = javaType.clusters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesClustersCluster.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            kubeConfigFilePrefix = javaType.kubeConfigFilePrefix().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
