@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property isOwner Indicates whether the permissions are granted to the cluster owner. Valid values `false`, `true`.
 * @property isRamRole Indicates whether the permissions are granted to the RAM role. Valid values `false`, `true`.
 * @property resourceId The permission settings to manage ACK clusters.
 * @property resourceType The authorization type. Valid values `cluster`, `namespace` and `console`.
 * @property roleName The name of the predefined role. If a custom role is assigned, the value is the name of the assigined custom role.
 * @property roleType The predefined role. Valid values `admin`,`ops`,`dev`,`restricted` and `custom`.
 */
public data class GetKubernetesPermissionPermission(
    public val isOwner: Boolean,
    public val isRamRole: Boolean,
    public val resourceId: String,
    public val resourceType: String,
    public val roleName: String,
    public val roleType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetKubernetesPermissionPermission): GetKubernetesPermissionPermission = GetKubernetesPermissionPermission(
            isOwner = javaType.isOwner(),
            isRamRole = javaType.isRamRole(),
            resourceId = javaType.resourceId(),
            resourceType = javaType.resourceType(),
            roleName = javaType.roleName(),
            roleType = javaType.roleType(),
        )
    }
}
