@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getKubernetesPermission.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property permissions A list of user permission. See `permissions` below.
 * @property uid The ID of the RAM user. If you want to query the permissions of a RAM role, specify the ID of the RAM role.
 */
public data class GetKubernetesPermissionResult(
    public val id: String,
    public val permissions: List<GetKubernetesPermissionPermission>,
    public val uid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetKubernetesPermissionResult): GetKubernetesPermissionResult = GetKubernetesPermissionResult(
            id = javaType.id(),
            permissions = javaType.permissions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesPermissionPermission.Companion.toKotlin(args0)
                })
            }),
            uid = javaType.uid(),
        )
    }
}
