@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property runtimes The list of supported runtime.
 * @property version The runtime version.
 */
public data class GetKubernetesVersionMetadata(
    public val runtimes: List<GetKubernetesVersionMetadataRuntime>,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetKubernetesVersionMetadata): GetKubernetesVersionMetadata = GetKubernetesVersionMetadata(
            runtimes = javaType.runtimes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesVersionMetadataRuntime.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version(),
        )
    }
}
