@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getKubernetesVersion.
 * @property clusterType
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kubernetesVersion
 * @property metadatas A list of metadata of kubernetes version.
 * @property profile
 */
public data class GetKubernetesVersionResult(
    public val clusterType: String,
    public val id: String,
    public val kubernetesVersion: String? = null,
    public val metadatas: List<GetKubernetesVersionMetadata>,
    public val profile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetKubernetesVersionResult): GetKubernetesVersionResult = GetKubernetesVersionResult(
            clusterType = javaType.clusterType(),
            id = javaType.id(),
            kubernetesVersion = javaType.kubernetesVersion().map({ args0 -> args0 }).orElse(null),
            metadatas = javaType.metadatas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesVersionMetadata.Companion.toKotlin(args0)
                })
            }),
            profile = javaType.profile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
