@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZone The ID of availability zone.
 * @property clusterNetworkType
 * @property connections Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
 * @property id ID of the node.
 * @property imageId
 * @property keyName The keypair of ssh login cluster node, you have to create it first.
 * @property logConfigs A list of one element containing information about the associated log store. It contains the following attributes:
 * @property name Node name.
 * @property natGatewayId The ID of nat gateway used to launch kubernetes cluster.
 * @property podCidr
 * @property securityGroupId The ID of security group where the current cluster worker node is located.
 * @property serviceCidr
 * @property slbInternetEnabled
 * @property vpcId The ID of VPC where the current cluster is located.
 * @property vswitchIds The ID of VSwitches where the current cluster is located.
 * @property workerAutoRenew
 * @property workerAutoRenewPeriod
 * @property workerDataDiskCategory
 * @property workerDataDiskSize
 * @property workerDiskCategory
 * @property workerDiskSize
 * @property workerInstanceChargeType
 * @property workerInstanceTypes
 * @property workerNodes List of cluster worker nodes. It contains several attributes to `Block Nodes`.
 * @property workerNumbers The ECS instance node number in the current container cluster.
 * @property workerPeriod
 * @property workerPeriodUnit
 */
public data class GetManagedKubernetesClustersCluster(
    public val availabilityZone: String,
    public val clusterNetworkType: String,
    public val connections: GetManagedKubernetesClustersClusterConnections,
    public val id: String,
    public val imageId: String,
    public val keyName: String,
    public val logConfigs: List<GetManagedKubernetesClustersClusterLogConfig>,
    public val name: String,
    public val natGatewayId: String,
    public val podCidr: String,
    public val securityGroupId: String,
    public val serviceCidr: String,
    public val slbInternetEnabled: Boolean,
    public val vpcId: String,
    public val vswitchIds: List<String>,
    public val workerAutoRenew: Boolean,
    public val workerAutoRenewPeriod: Int,
    public val workerDataDiskCategory: String,
    public val workerDataDiskSize: Int,
    public val workerDiskCategory: String,
    public val workerDiskSize: Int,
    public val workerInstanceChargeType: String,
    public val workerInstanceTypes: List<String>,
    public val workerNodes: List<GetManagedKubernetesClustersClusterWorkerNode>,
    public val workerNumbers: List<Int>,
    public val workerPeriod: Int,
    public val workerPeriodUnit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetManagedKubernetesClustersCluster): GetManagedKubernetesClustersCluster = GetManagedKubernetesClustersCluster(
            availabilityZone = javaType.availabilityZone(),
            clusterNetworkType = javaType.clusterNetworkType(),
            connections = javaType.connections().let({ args0 ->
                com.pulumi.alicloud.cs.kotlin.outputs.GetManagedKubernetesClustersClusterConnections.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            imageId = javaType.imageId(),
            keyName = javaType.keyName(),
            logConfigs = javaType.logConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetManagedKubernetesClustersClusterLogConfig.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            natGatewayId = javaType.natGatewayId(),
            podCidr = javaType.podCidr(),
            securityGroupId = javaType.securityGroupId(),
            serviceCidr = javaType.serviceCidr(),
            slbInternetEnabled = javaType.slbInternetEnabled(),
            vpcId = javaType.vpcId(),
            vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
            workerAutoRenew = javaType.workerAutoRenew(),
            workerAutoRenewPeriod = javaType.workerAutoRenewPeriod(),
            workerDataDiskCategory = javaType.workerDataDiskCategory(),
            workerDataDiskSize = javaType.workerDataDiskSize(),
            workerDiskCategory = javaType.workerDiskCategory(),
            workerDiskSize = javaType.workerDiskSize(),
            workerInstanceChargeType = javaType.workerInstanceChargeType(),
            workerInstanceTypes = javaType.workerInstanceTypes().map({ args0 -> args0 }),
            workerNodes = javaType.workerNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetManagedKubernetesClustersClusterWorkerNode.Companion.toKotlin(args0)
                })
            }),
            workerNumbers = javaType.workerNumbers().map({ args0 -> args0 }),
            workerPeriod = javaType.workerPeriod(),
            workerPeriodUnit = javaType.workerPeriodUnit(),
        )
    }
}
