@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property authorizationToken The password that was used to log on to the registry.
 * @property id ID of Container Registry Enterprise Edition instance.
 * @property name Name of Container Registry Enterprise Edition instance.
 * @property namespaceQuota The max number of namespaces that an instance can create.
 * @property namespaceUsage The number of namespaces already created.
 * @property publicEndpoints A list of domains for access on internet network.
 * @property region Region of Container Registry Enterprise Edition instance.
 * @property repoQuota The max number of repos that an instance can create.
 * @property repoUsage The number of repos already created.
 * @property specification Specification of Container Registry Enterprise Edition instance.
 * @property tempUsername The username that was used to log on to the registry.
 * @property vpcEndpoints A list of domains for access on vpc network.
 */
public data class GetRegistryEnterpriseInstancesInstance(
    public val authorizationToken: String,
    public val id: String,
    public val name: String,
    public val namespaceQuota: String,
    public val namespaceUsage: String,
    public val publicEndpoints: List<String>,
    public val region: String,
    public val repoQuota: String,
    public val repoUsage: String,
    public val specification: String,
    public val tempUsername: String,
    public val vpcEndpoints: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetRegistryEnterpriseInstancesInstance): GetRegistryEnterpriseInstancesInstance = GetRegistryEnterpriseInstancesInstance(
            authorizationToken = javaType.authorizationToken(),
            id = javaType.id(),
            name = javaType.name(),
            namespaceQuota = javaType.namespaceQuota(),
            namespaceUsage = javaType.namespaceUsage(),
            publicEndpoints = javaType.publicEndpoints().map({ args0 -> args0 }),
            region = javaType.region(),
            repoQuota = javaType.repoQuota(),
            repoUsage = javaType.repoUsage(),
            specification = javaType.specification(),
            tempUsername = javaType.tempUsername(),
            vpcEndpoints = javaType.vpcEndpoints().map({ args0 -> args0 }),
        )
    }
}
