@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoCreate Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
 * @property defaultVisibility `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
 * @property id ID of Container Registry Enterprise Edition namespace. It formats as `<instance_id>:<namespace_name>`. Before 1.161.0, it is a namespace uuid.
 * @property instanceId ID of Container Registry Enterprise Edition instance.
 * @property name Name of Container Registry Enterprise Edition namespace.
 * @property namespaceId Container Registry Enterprise Edition namespace id. It is a uuid.
 * @property namespaceName Name of Container Registry Enterprise Edition namespace.
 */
public data class GetRegistryEnterpriseNamespacesNamespace(
    public val autoCreate: Boolean,
    public val defaultVisibility: String,
    public val id: String,
    public val instanceId: String,
    public val name: String,
    public val namespaceId: String,
    public val namespaceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetRegistryEnterpriseNamespacesNamespace): GetRegistryEnterpriseNamespacesNamespace = GetRegistryEnterpriseNamespacesNamespace(
            autoCreate = javaType.autoCreate(),
            defaultVisibility = javaType.defaultVisibility(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            name = javaType.name(),
            namespaceId = javaType.namespaceId(),
            namespaceName = javaType.namespaceName(),
        )
    }
}
