@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRegistryEnterpriseNamespaces.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of matched Container Registry Enterprise Edition namespaces. Each item formats as `<instance_id>:<namespace_name>`. Before 1.161.0, its element is a namespace uuid.
 * @property instanceId ID of Container Registry Enterprise Edition instance.
 * @property nameRegex
 * @property names A list of namespace names.
 * @property namespaces A list of matched Container Registry Enterprise Edition namespaces. Each element contains the following attributes:
 * @property outputFile
 */
public data class GetRegistryEnterpriseNamespacesResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val namespaces: List<GetRegistryEnterpriseNamespacesNamespace>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetRegistryEnterpriseNamespacesResult): GetRegistryEnterpriseNamespacesResult = GetRegistryEnterpriseNamespacesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            namespaces = javaType.namespaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetRegistryEnterpriseNamespacesNamespace.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
