@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id ID of Container Registry Enterprise Edition repository.
 * @property instanceId ID of Container Registry Enterprise Edition instance.
 * @property name Name of Container Registry Enterprise Edition repository.
 * @property namespace Name of Container Registry Enterprise Edition namespace where the repositories are located in.
 * @property repoType `PUBLIC` or `PRIVATE`, repository's visibility.
 * @property summary The repository general information.
 * @property tags A list of image tags belong to this repository. Each contains several attributes, see `Block Tag`.
 */
public data class GetRegistryEnterpriseReposRepo(
    public val id: String,
    public val instanceId: String,
    public val name: String,
    public val namespace: String,
    public val repoType: String,
    public val summary: String,
    public val tags: List<GetRegistryEnterpriseReposRepoTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetRegistryEnterpriseReposRepo): GetRegistryEnterpriseReposRepo = GetRegistryEnterpriseReposRepo(
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            name = javaType.name(),
            namespace = javaType.namespace(),
            repoType = javaType.repoType(),
            summary = javaType.summary(),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetRegistryEnterpriseReposRepoTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
