@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property digest Digest of this image.
 * @property imageCreate Create time of this image, unix time in nanoseconds.
 * @property imageId Id of this image.
 * @property imageSize Status of this image, in bytes.
 * @property imageUpdate Last update time of this image, unix time in nanoseconds.
 * @property status Status of this image.
 * @property tag Tag of this image.
 */
public data class GetRegistryEnterpriseReposRepoTag(
    public val digest: String,
    public val imageCreate: String,
    public val imageId: String,
    public val imageSize: Int,
    public val imageUpdate: String,
    public val status: String,
    public val tag: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetRegistryEnterpriseReposRepoTag): GetRegistryEnterpriseReposRepoTag = GetRegistryEnterpriseReposRepoTag(
            digest = javaType.digest(),
            imageCreate = javaType.imageCreate(),
            imageId = javaType.imageId(),
            imageSize = javaType.imageSize(),
            imageUpdate = javaType.imageUpdate(),
            status = javaType.status(),
            tag = javaType.tag(),
        )
    }
}
