@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRegistryEnterpriseRepos.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of matched Container Registry Enterprise Edition repositories. Its element is a repository id.
 * @property instanceId ID of Container Registry Enterprise Edition instance.
 * @property nameRegex
 * @property names A list of repository names.
 * @property namespace Name of Container Registry Enterprise Edition namespace where repo is located.
 * @property outputFile
 * @property repos A list of matched Container Registry Enterprise Edition namespaces. Each element contains the following attributes:
 */
public data class GetRegistryEnterpriseReposResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val namespace: String? = null,
    public val outputFile: String? = null,
    public val repos: List<GetRegistryEnterpriseReposRepo>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetRegistryEnterpriseReposResult): GetRegistryEnterpriseReposResult = GetRegistryEnterpriseReposResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            repos = javaType.repos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetRegistryEnterpriseReposRepo.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
