@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRegistryEnterpriseSyncRules.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of matched Container Registry Enterprise Edition sync rules. Its element is a sync rule uuid.
 * @property instanceId ID of Container Registry Enterprise Edition local instance.
 * @property nameRegex
 * @property names A list of sync rule names.
 * @property namespaceName Name of Container Registry Enterprise Edition local namespace.
 * @property outputFile
 * @property repoName Name of Container Registry Enterprise Edition local repo.
 * @property rules A list of matched Container Registry Enterprise Edition sync rules. Each element contains the following attributes:
 * @property targetInstanceId ID of Container Registry Enterprise Edition target instance.
 */
public data class GetRegistryEnterpriseSyncRulesResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val namespaceName: String? = null,
    public val outputFile: String? = null,
    public val repoName: String? = null,
    public val rules: List<GetRegistryEnterpriseSyncRulesRule>,
    public val targetInstanceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetRegistryEnterpriseSyncRulesResult): GetRegistryEnterpriseSyncRulesResult = GetRegistryEnterpriseSyncRulesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            namespaceName = javaType.namespaceName().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            repoName = javaType.repoName().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.GetRegistryEnterpriseSyncRulesRule.Companion.toKotlin(args0)
                })
            }),
            targetInstanceId = javaType.targetInstanceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
