@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id ID of Container Registry Enterprise Edition sync rule.
 * @property instanceId ID of Container Registry Enterprise Edition local instance.
 * @property name Name of Container Registry Enterprise Edition sync rule.
 * @property namespaceName Name of Container Registry Enterprise Edition local namespace.
 * @property regionId Region of Container Registry Enterprise Edition local instance.
 * @property repoName Name of Container Registry Enterprise Edition local repo.
 * @property syncDirection `FROM` or `TO`, the direction of synchronization. `FROM` indicates that the local instance is the source instance. `TO` indicates that the local instance is the target instance to be synchronized.
 * @property syncScope `REPO` or `NAMESPACE`,the scope that the synchronization rule applies.
 * @property syncTrigger `PASSIVE` or `INITIATIVE`, the policy configured to trigger the synchronization rule.
 * @property tagFilter The regular expression used to filter image tags for synchronization in the source repository.
 * @property targetInstanceId ID of Container Registry Enterprise Edition target instance.
 * @property targetNamespaceName Name of Container Registry Enterprise Edition target namespace.
 * @property targetRegionId Region of Container Registry Enterprise Edition target instance.
 * @property targetRepoName Name of Container Registry Enterprise Edition target repo.
 */
public data class GetRegistryEnterpriseSyncRulesRule(
    public val id: String,
    public val instanceId: String,
    public val name: String,
    public val namespaceName: String,
    public val regionId: String,
    public val repoName: String,
    public val syncDirection: String,
    public val syncScope: String,
    public val syncTrigger: String,
    public val tagFilter: String,
    public val targetInstanceId: String,
    public val targetNamespaceName: String,
    public val targetRegionId: String,
    public val targetRepoName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetRegistryEnterpriseSyncRulesRule): GetRegistryEnterpriseSyncRulesRule = GetRegistryEnterpriseSyncRulesRule(
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            name = javaType.name(),
            namespaceName = javaType.namespaceName(),
            regionId = javaType.regionId(),
            repoName = javaType.repoName(),
            syncDirection = javaType.syncDirection(),
            syncScope = javaType.syncScope(),
            syncTrigger = javaType.syncTrigger(),
            tagFilter = javaType.tagFilter(),
            targetInstanceId = javaType.targetInstanceId(),
            targetNamespaceName = javaType.targetNamespaceName(),
            targetRegionId = javaType.targetRegionId(),
            targetRepoName = javaType.targetRepoName(),
        )
    }
}
