@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property connections Map of serverless cluster connection information. It contains several attributes to `Block Connections`.
 * @property deletionProtection Whether the cluster support delete protection.
 * @property endpointPublicAccessEnabled
 * @property id The ID of the container cluster.
 * @property name The name of the container cluster.
 * @property natGatewayId The ID of nat gateway used to launch kubernetes cluster.
 * @property securityGroupId The ID of security group where the current cluster  is located.
 * @property tags
 * @property vpcId The ID of VPC where the current cluster is located.
 * @property vswitchId The ID of vSwitch where the current cluster is located.
 */
public data class GetServerlessKubernetesClustersCluster(
    public val connections: GetServerlessKubernetesClustersClusterConnections,
    public val deletionProtection: Boolean,
    public val endpointPublicAccessEnabled: Boolean,
    public val id: String,
    public val name: String,
    public val natGatewayId: String,
    public val securityGroupId: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetServerlessKubernetesClustersCluster): GetServerlessKubernetesClustersCluster = GetServerlessKubernetesClustersCluster(
            connections = javaType.connections().let({ args0 ->
                com.pulumi.alicloud.cs.kotlin.outputs.GetServerlessKubernetesClustersClusterConnections.Companion.toKotlin(args0)
            }),
            deletionProtection = javaType.deletionProtection(),
            endpointPublicAccessEnabled = javaType.endpointPublicAccessEnabled(),
            id = javaType.id(),
            name = javaType.name(),
            natGatewayId = javaType.natGatewayId(),
            securityGroupId = javaType.securityGroupId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
