@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiServerInternet API Server Internet endpoint.
 * @property apiServerIntranet API Server Intranet endpoint.
 * @property masterPublicIp Master node SSH IP address.
 */
public data class GetServerlessKubernetesClustersClusterConnections(
    public val apiServerInternet: String,
    public val apiServerIntranet: String,
    public val masterPublicIp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.GetServerlessKubernetesClustersClusterConnections): GetServerlessKubernetesClustersClusterConnections =
            GetServerlessKubernetesClustersClusterConnections(
                apiServerInternet = javaType.apiServerInternet(),
                apiServerIntranet = javaType.apiServerIntranet(),
                masterPublicIp = javaType.masterPublicIp(),
            )
    }
}
