@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteMode The deletion mode of the cluster. Different resources may have different default behavior, see `resource_type` for details. Valid values:
 * @property resourceType The type of resources that are created by cluster. Valid values:
 * - `SLB`: SLB resources created through the service, default behavior is to delete, option to retain is available.
 * - `ALB`: ALB resources created by the ALB Ingress Controller, default behavior is to retain, option to delete is available.
 * - `SLS_Data`: SLS Project used by the cluster logging feature, default behavior is to retain, option to delete is available.
 * - `SLS_ControlPlane`: SLS Project used for the managed cluster control plane logs, default behavior is to retain, option to delete is available.
 * ```
 * ...
 * // Specify delete_options as below when deleting cluster
 * // delete SLB resources created by the cluster
 * delete_options {
 * delete_mode = "delete"
 * resource_type = "SLB"
 * }
 * // delete ALB resources created by the ALB Ingress Controller
 * delete_options {
 * delete_mode = "delete"
 * resource_type = "ALB"
 * }
 * // delete SLS Project used by the cluster logging feature
 * delete_options {
 * delete_mode = "delete"
 * resource_type = "SLS_Data"
 * }
 * // delete SLS Project used for the managed cluster control plane logs
 * delete_options {
 * delete_mode = "delete"
 * resource_type = "SLS_ControlPlane"
 * }
 * ```
 */
public data class KubernetesDeleteOption(
    public val deleteMode: String? = null,
    public val resourceType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.KubernetesDeleteOption): KubernetesDeleteOption = KubernetesDeleteOption(
            deleteMode = javaType.deleteMode().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
