@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cluster The ID of the cluster that you want to manage, When `role_type` value is `all-clusters`, the value of `cluster` must be `""`.
 * @property isCustom Specifies whether to perform a custom authorization. To perform a custom authorization, the value of `is_custom` must be `true`, and set `role_name` to a custom cluster role.
 * @property isRamRole Specifies whether the permissions are granted to a RAM role. When `uid` is ram role id, the value of `is_ram_role` must be `true`.
 * @property namespace The namespace to which the permissions are scoped. This parameter is required only if you set role_type to namespace.
 * @property roleName Specifies the predefined role that you want to assign. Valid values `admin`, `ops`, `dev`, `restricted` and the custom cluster roles.
 * @property roleType The authorization type. Valid values `cluster`, `namespace` and `all-clusters`.
 */
public data class KubernetesPermissionPermission(
    public val cluster: String,
    public val isCustom: Boolean? = null,
    public val isRamRole: Boolean? = null,
    public val namespace: String? = null,
    public val roleName: String,
    public val roleType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.KubernetesPermissionPermission): KubernetesPermissionPermission = KubernetesPermissionPermission(
            cluster = javaType.cluster(),
            isCustom = javaType.isCustom().map({ args0 -> args0 }).orElse(null),
            isRamRole = javaType.isRamRole().map({ args0 -> args0 }).orElse(null),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            roleName = javaType.roleName(),
            roleType = javaType.roleType(),
        )
    }
}
