@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property config If this parameter is left empty, no configurations are required. For more config information, see cs_kubernetes_addon_metadata.
 * @property disabled It specifies whether to disable automatic installation.
 * It is a new field since 1.75.0. You can specific network plugin, log component,ingress component and so on.
 * You can get more information about addons on ACK web console. When you create a ACK cluster. You can get openapi-spec before creating the cluster on submission page.
 * `logtail-ds` - You can specify `IngressDashboardEnabled` and `sls_project_name` in config. If you switch on `IngressDashboardEnabled` and `sls_project_name`,then logtail-ds would use `sls_project_name` as default log store.
 * `nginx-ingress-controller` - You can specific `IngressSlbNetworkType` in config. Options: internet|intranet.
 * The `main.tf`:
 * @property name This parameter specifies the name of the component.
 * @property version It specifies the version of the component.
 */
public data class ManagedKubernetesAddon(
    public val config: String? = null,
    public val disabled: Boolean? = null,
    public val name: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.ManagedKubernetesAddon): ManagedKubernetesAddon = ManagedKubernetesAddon(
            config = javaType.config().map({ args0 -> args0 }).orElse(null),
            disabled = javaType.disabled().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
