@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clientCert The base64 encoded client certificate data required to communicate with your cluster. Add this to the client-certificate-data section of the kubeconfig file for your cluster.
 * @property clientKey The base64 encoded client key data required to communicate with your cluster. Add this to the client-key-data section of the kubeconfig file for your cluster.
 * @property clusterCert The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
 */
public data class ManagedKubernetesCertificateAuthority(
    public val clientCert: String? = null,
    public val clientKey: String? = null,
    public val clusterCert: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.ManagedKubernetesCertificateAuthority): ManagedKubernetesCertificateAuthority = ManagedKubernetesCertificateAuthority(
            clientCert = javaType.clientCert().map({ args0 -> args0 }).orElse(null),
            clientKey = javaType.clientKey().map({ args0 -> args0 }).orElse(null),
            clusterCert = javaType.clusterCert().map({ args0 -> args0 }).orElse(null),
        )
    }
}
