@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiServerInternet API Server Internet endpoint.
 * @property apiServerIntranet API Server Intranet endpoint.
 * @property masterPublicIp Master node SSH IP address.
 * @property serviceDomain Service Access Domain.
 */
public data class ManagedKubernetesConnections(
    public val apiServerInternet: String? = null,
    public val apiServerIntranet: String? = null,
    public val masterPublicIp: String? = null,
    public val serviceDomain: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.ManagedKubernetesConnections): ManagedKubernetesConnections = ManagedKubernetesConnections(
            apiServerInternet = javaType.apiServerInternet().map({ args0 -> args0 }).orElse(null),
            apiServerIntranet = javaType.apiServerIntranet().map({ args0 -> args0 }).orElse(null),
            masterPublicIp = javaType.masterPublicIp().map({ args0 -> args0 }).orElse(null),
            serviceDomain = javaType.serviceDomain().map({ args0 -> args0 }).orElse(null),
        )
    }
}
