@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property duration The maintenance time, values range from 1 to 24,unit is hour. For example: "3h".
 * @property enable Whether to open the maintenance window. The following parameters take effect only `enable = true`.
 * @property maintenanceTime Initial maintenance time, For example:"03:00:00Z".
 * @property weeklyPeriod Maintenance cycle, you can set the values from Monday to Sunday, separated by commas when the values are multiple. The default is Thursday.
 * for example:
 * ```
 * maintenance_window {
 * enable            = true
 * maintenance_time  = "01:00:00Z"
 * duration          = "3h"
 * weekly_period     = "Monday,Friday"
 * }
 * ```
 */
public data class ManagedKubernetesMaintenanceWindow(
    public val duration: String,
    public val enable: Boolean,
    public val maintenanceTime: String,
    public val weeklyPeriod: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.ManagedKubernetesMaintenanceWindow): ManagedKubernetesMaintenanceWindow = ManagedKubernetesMaintenanceWindow(
            duration = javaType.duration(),
            enable = javaType.enable(),
            maintenanceTime = javaType.maintenanceTime(),
            weeklyPeriod = javaType.weeklyPeriod(),
        )
    }
}
