@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoFormat Whether to automatically mount the data disk. Valid values: true and false.
 * @property autoSnapshotPolicyId The ID of the automatic snapshot policy that you want to apply to the system disk.
 * @property burstingEnabled Whether the data disk is enabled with Burst (performance Burst). This is configured when the disk type is cloud_auto.
 * @property category The type of the data disks. Valid values:`cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`.
 * @property device The mount target of data disk N. Valid values of N: 1 to 16. If you do not specify this parameter, the system automatically assigns a mount target when Auto Scaling creates ECS instances. The name of the mount target ranges from /dev/xvdb to /dev/xvdz.
 * @property encrypted Specifies whether to encrypt data disks. Valid values: true and false. Default to `false`.
 * @property fileSystem The Mount path. Works when auto_format is true.
 * @property kmsKeyId The kms key id used to encrypt the data disk. It takes effect when `encrypted` is true.
 * @property mountTarget The type of the mounted file system. Works when auto_format is true. Optional value: `ext4`, `xfs`.
 * @property name The length is 2~128 English or Chinese characters. It must start with an uppercase or lowr letter or a Chinese character and cannot start with http:// or https. Can contain numbers, colons (:), underscores (_), or dashes (-). It will be overwritten if auto_format is set.
 * @property performanceLevel Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
 * @property provisionedIops The read/write IOPS preconfigured for the data disk, which is configured when the disk type is cloud_auto.
 * @property size The size of a data disk, Its valid value range [40~32768] in GB. Default to `40`.
 * @property snapshotId The ID of the snapshot that you want to use to create data disk N. Valid values of N: 1 to 16. If you specify this parameter, DataDisk.N.Size is ignored. The size of the disk is the same as the size of the specified snapshot. If you specify a snapshot that is created on or before July 15, 2013, the operation fails and InvalidSnapshot.TooOld is returned.
 */
public data class NodePoolDataDisk(
    public val autoFormat: String? = null,
    public val autoSnapshotPolicyId: String? = null,
    public val burstingEnabled: Boolean? = null,
    public val category: String? = null,
    public val device: String? = null,
    public val encrypted: String? = null,
    public val fileSystem: String? = null,
    public val kmsKeyId: String? = null,
    public val mountTarget: String? = null,
    public val name: String? = null,
    public val performanceLevel: String? = null,
    public val provisionedIops: Int? = null,
    public val size: Int? = null,
    public val snapshotId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.NodePoolDataDisk): NodePoolDataDisk = NodePoolDataDisk(
            autoFormat = javaType.autoFormat().map({ args0 -> args0 }).orElse(null),
            autoSnapshotPolicyId = javaType.autoSnapshotPolicyId().map({ args0 -> args0 }).orElse(null),
            burstingEnabled = javaType.burstingEnabled().map({ args0 -> args0 }).orElse(null),
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            device = javaType.device().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            fileSystem = javaType.fileSystem().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            mountTarget = javaType.mountTarget().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            performanceLevel = javaType.performanceLevel().map({ args0 -> args0 }).orElse(null),
            provisionedIops = javaType.provisionedIops().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
