@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property allowedUnsafeSysctls Allowed sysctl mode whitelist.
 * @property containerLogMaxFiles The maximum number of log files that can exist in each container.
 * @property containerLogMaxSize The maximum size that can be reached before a log file is rotated.
 * @property cpuManagerPolicy Same as cpuManagerPolicy. The name of the policy to use. Requires the CPUManager feature gate to be enabled. Valid value is `none` or `static`.
 * @property eventBurst Same as eventBurst. The maximum size of a burst of event creations, temporarily allows event creations to burst to this number, while still not exceeding `event_record_qps`. It is only used when `event_record_qps` is greater than 0. Valid value is `[0-100]`.
 * @property eventRecordQps Same as eventRecordQPS. The maximum event creations per second. If 0, there is no limit enforced. Valid value is `[0-50]`.
 * @property evictionHard Same as evictionHard. The map of signal names to quantities that defines hard eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
 * @property evictionSoft Same as evictionSoft. The map of signal names to quantities that defines soft eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
 * @property evictionSoftGracePeriod Same as evictionSoftGracePeriod. The map of signal names to quantities that defines grace periods for each soft eviction signal. For example: `{"memory.available" = "30s"}`.
 * @property featureGates Feature switch to enable configuration of experimental features.
 * @property kubeApiBurst Same as kubeAPIBurst. The burst to allow while talking with kubernetes api-server. Valid value is `[0-100]`.
 * @property kubeApiQps Same as kubeAPIQPS. The QPS to use while talking with kubernetes api-server. Valid value is `[0-50]`.
 * @property kubeReserved Same as kubeReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently, cpu, memory and local storage for root file system are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
 * @property maxPods The maximum number of running pods.
 * @property readOnlyPort Read-only port number.
 * @property registryBurst Same as registryBurst. The maximum size of burst pulls, temporarily allows pulls to burst to this number, while still not exceeding `registry_pull_qps`. Only used if `registry_pull_qps` is greater than 0. Valid value is `[0-100]`.
 * @property registryPullQps Same as registryPullQPS. The limit of registry pulls per second. Setting it to `0` means no limit. Valid value is `[0-50]`.
 * @property serializeImagePulls Same as serializeImagePulls. When enabled, it tells the Kubelet to pull images one at a time. We recommend not changing the default value on nodes that run docker daemon with version < 1.9 or an Aufs storage backend. Valid value is `true` or `false`.
 * @property systemReserved Same as systemReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently, only cpu and memory are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
 */
public data class NodePoolKubeletConfiguration(
    public val allowedUnsafeSysctls: List<String>? = null,
    public val containerLogMaxFiles: String? = null,
    public val containerLogMaxSize: String? = null,
    public val cpuManagerPolicy: String? = null,
    public val eventBurst: String? = null,
    public val eventRecordQps: String? = null,
    public val evictionHard: Map<String, String>? = null,
    public val evictionSoft: Map<String, String>? = null,
    public val evictionSoftGracePeriod: Map<String, String>? = null,
    public val featureGates: Map<String, Boolean>? = null,
    public val kubeApiBurst: String? = null,
    public val kubeApiQps: String? = null,
    public val kubeReserved: Map<String, String>? = null,
    public val maxPods: String? = null,
    public val readOnlyPort: String? = null,
    public val registryBurst: String? = null,
    public val registryPullQps: String? = null,
    public val serializeImagePulls: String? = null,
    public val systemReserved: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.NodePoolKubeletConfiguration): NodePoolKubeletConfiguration = NodePoolKubeletConfiguration(
            allowedUnsafeSysctls = javaType.allowedUnsafeSysctls().map({ args0 -> args0 }),
            containerLogMaxFiles = javaType.containerLogMaxFiles().map({ args0 -> args0 }).orElse(null),
            containerLogMaxSize = javaType.containerLogMaxSize().map({ args0 -> args0 }).orElse(null),
            cpuManagerPolicy = javaType.cpuManagerPolicy().map({ args0 -> args0 }).orElse(null),
            eventBurst = javaType.eventBurst().map({ args0 -> args0 }).orElse(null),
            eventRecordQps = javaType.eventRecordQps().map({ args0 -> args0 }).orElse(null),
            evictionHard = javaType.evictionHard().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            evictionSoft = javaType.evictionSoft().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            evictionSoftGracePeriod = javaType.evictionSoftGracePeriod().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            featureGates = javaType.featureGates().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            kubeApiBurst = javaType.kubeApiBurst().map({ args0 -> args0 }).orElse(null),
            kubeApiQps = javaType.kubeApiQps().map({ args0 -> args0 }).orElse(null),
            kubeReserved = javaType.kubeReserved().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            maxPods = javaType.maxPods().map({ args0 -> args0 }).orElse(null),
            readOnlyPort = javaType.readOnlyPort().map({ args0 -> args0 }).orElse(null),
            registryBurst = javaType.registryBurst().map({ args0 -> args0 }).orElse(null),
            registryPullQps = javaType.registryPullQps().map({ args0 -> args0 }).orElse(null),
            serializeImagePulls = javaType.serializeImagePulls().map({ args0 -> args0 }).orElse(null),
            systemReserved = javaType.systemReserved().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
