@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property autoRepair Whether to enable automatic repair. Valid values: `true`: Automatic repair. `false`: not automatically repaired.
 * @property autoRepairPolicy Automatic repair node policy. See `auto_repair_policy` below.
 * @property autoUpgrade Specifies whether to enable auto update. Valid values: `true`: enables auto update. `false`: disables auto update.
 * @property autoUpgradePolicy The auto update policy. See `auto_upgrade_policy` below.
 * @property autoVulFix Specifies whether to automatically patch CVE vulnerabilities. Valid values: `true`, `false`.
 * @property autoVulFixPolicy The auto CVE patching policy. See `auto_vul_fix_policy` below.
 * @property enable Specifies whether to enable the managed node pool feature. Valid values: `true`: enables the managed node pool feature. `false`: disables the managed node pool feature. Other parameters in this section take effect only when you specify enable=true.
 * @property maxUnavailable Maximum number of unavailable nodes. Default value: 1. Value range:\[1,1000\].
 * @property surge Number of additional nodes. You have to specify one of surge, surge_percentage.
 * @property surgePercentage Proportion of additional nodes. You have to specify one of surge, surge_percentage.
 */
public data class NodePoolManagement(
    public val autoRepair: Boolean? = null,
    public val autoRepairPolicy: NodePoolManagementAutoRepairPolicy? = null,
    public val autoUpgrade: Boolean? = null,
    public val autoUpgradePolicy: NodePoolManagementAutoUpgradePolicy? = null,
    public val autoVulFix: Boolean? = null,
    public val autoVulFixPolicy: NodePoolManagementAutoVulFixPolicy? = null,
    public val enable: Boolean? = null,
    public val maxUnavailable: Int? = null,
    @Deprecated(
        message = """
  Field 'surge' has been deprecated from provider version 1.219.0. Number of additional nodes. You
      have to specify one of surge, surge_percentage.
  """,
    )
    public val surge: Int? = null,
    @Deprecated(
        message = """
  Field 'surge_percentage' has been deprecated from provider version 1.219.0. Proportion of
      additional nodes. You have to specify one of surge, surge_percentage.
  """,
    )
    public val surgePercentage: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.NodePoolManagement): NodePoolManagement = NodePoolManagement(
            autoRepair = javaType.autoRepair().map({ args0 -> args0 }).orElse(null),
            autoRepairPolicy = javaType.autoRepairPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.NodePoolManagementAutoRepairPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoUpgrade = javaType.autoUpgrade().map({ args0 -> args0 }).orElse(null),
            autoUpgradePolicy = javaType.autoUpgradePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.NodePoolManagementAutoUpgradePolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoVulFix = javaType.autoVulFix().map({ args0 -> args0 }).orElse(null),
            autoVulFixPolicy = javaType.autoVulFixPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cs.kotlin.outputs.NodePoolManagementAutoVulFixPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            maxUnavailable = javaType.maxUnavailable().map({ args0 -> args0 }).orElse(null),
            surge = javaType.surge().map({ args0 -> args0 }).orElse(null),
            surgePercentage = javaType.surgePercentage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
