@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property restartNode Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
 * @property vulLevel The severity levels of vulnerabilities that is allowed to automatically patch. Multiple severity levels are separated by commas (,).
 */
public data class NodePoolManagementAutoVulFixPolicy(
    public val restartNode: Boolean? = null,
    public val vulLevel: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.NodePoolManagementAutoVulFixPolicy): NodePoolManagementAutoVulFixPolicy = NodePoolManagementAutoVulFixPolicy(
            restartNode = javaType.restartNode().map({ args0 -> args0 }).orElse(null),
            vulLevel = javaType.vulLevel().map({ args0 -> args0 }).orElse(null),
        )
    }
}
