@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property privatePoolOptionsId The ID of the private node pool.
 * @property privatePoolOptionsMatchCriteria The type of private node pool. This parameter specifies the type of the private pool that you want to use to create instances. A private node pool is generated when an elasticity assurance or a capacity reservation service takes effect. The system selects a private node pool to launch instances. Valid values: `Open`: specifies an open private node pool. The system selects an open private node pool to launch instances. If no matching open private node pool is available, the resources in the public node pool are used. `Target`: specifies a private node pool. The system uses the resources of the specified private node pool to launch instances. If the specified private node pool is unavailable, instances cannot be started. `None`: no private node pool is used. The resources of private node pools are not used to launch the instances.
 */
public data class NodePoolPrivatePoolOptions(
    public val privatePoolOptionsId: String? = null,
    public val privatePoolOptionsMatchCriteria: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.NodePoolPrivatePoolOptions): NodePoolPrivatePoolOptions = NodePoolPrivatePoolOptions(
            privatePoolOptionsId = javaType.privatePoolOptionsId().map({ args0 -> args0 }).orElse(null),
            privatePoolOptionsMatchCriteria = javaType.privatePoolOptionsMatchCriteria().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
