@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property eipBandwidth Peak EIP bandwidth. Its valid value range [1~500] in Mbps. It works if `is_bond_eip=true`. Default to `5`.
 * @property eipInternetChargeType EIP billing type. `PayByBandwidth`: Charged at fixed bandwidth. `PayByTraffic`: Billed as used traffic. Default: `PayByBandwidth`. It works if `is_bond_eip=true`, conflict with `internet_charge_type`. EIP and public network IP can only choose one.
 * @property enable Whether to enable automatic scaling. Value:
 * @property isBondEip Whether to bind EIP for an instance. Default: `false`.
 * @property maxSize Max number of instances in a auto scaling group, its valid value range [0~1000]. `max_size` has to be greater than `min_size`.
 * @property minSize Min number of instances in a auto scaling group, its valid value range [0~1000].
 * @property type Instance classification, not required. Vaild value: `cpu`, `gpu`, `gpushare` and `spot`. Default: `cpu`. The actual instance type is determined by `instance_types`.
 */
public data class NodePoolScalingConfig(
    public val eipBandwidth: Int? = null,
    public val eipInternetChargeType: String? = null,
    public val enable: Boolean? = null,
    public val isBondEip: Boolean? = null,
    public val maxSize: Int? = null,
    public val minSize: Int? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.NodePoolScalingConfig): NodePoolScalingConfig = NodePoolScalingConfig(
            eipBandwidth = javaType.eipBandwidth().map({ args0 -> args0 }).orElse(null),
            eipInternetChargeType = javaType.eipInternetChargeType().map({ args0 -> args0 }).orElse(null),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            isBondEip = javaType.isBondEip().map({ args0 -> args0 }).orElse(null),
            maxSize = javaType.maxSize().map({ args0 -> args0 }).orElse(null),
            minSize = javaType.minSize().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
