@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceType The type of the preemptible instance.
 * @property priceLimit The maximum price of a single instance.
 */
public data class NodePoolSpotPriceLimit(
    public val instanceType: String? = null,
    public val priceLimit: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.NodePoolSpotPriceLimit): NodePoolSpotPriceLimit = NodePoolSpotPriceLimit(
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            priceLimit = javaType.priceLimit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
