@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether the RRSA feature has been enabled.
 * @property ramOidcProviderArn The arn of OIDC provider that was registered in RAM.
 * @property ramOidcProviderName The name of OIDC Provider that was registered in RAM.
 * @property rrsaOidcIssuerUrl The issuer URL of RRSA OIDC Token.
 */
public data class ServerlessKubernetesRrsaMetadata(
    public val enabled: Boolean? = null,
    public val ramOidcProviderArn: String? = null,
    public val ramOidcProviderName: String? = null,
    public val rrsaOidcIssuerUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.ServerlessKubernetesRrsaMetadata): ServerlessKubernetesRrsaMetadata = ServerlessKubernetesRrsaMetadata(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            ramOidcProviderArn = javaType.ramOidcProviderArn().map({ args0 -> args0 }).orElse(null),
            ramOidcProviderName = javaType.ramOidcProviderName().map({ args0 -> args0 }).orElse(null),
            rrsaOidcIssuerUrl = javaType.rrsaOidcIssuerUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
