@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AutoSnapShotPolicy].
 */
@PulumiTagMarker
public class AutoSnapShotPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AutoSnapShotPolicyArgs = AutoSnapShotPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AutoSnapShotPolicyArgsBuilder.() -> Unit) {
        val builder = AutoSnapShotPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AutoSnapShotPolicy {
        val builtJavaResource =
            com.pulumi.alicloud.databasefilesystem.AutoSnapShotPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AutoSnapShotPolicy(builtJavaResource)
    }
}

/**
 * Provides a Dbfs Auto Snap Shot Policy resource.
 * For information about Dbfs Auto Snap Shot Policy and how to use it.
 * > **NOTE:** Available since v1.202.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.databasefilesystem.AutoSnapShotPolicy("default", {
 *     timePoints: ["01"],
 *     policyName: "tf-example",
 *     retentionDays: 1,
 *     repeatWeekdays: ["2"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.databasefilesystem.AutoSnapShotPolicy("default",
 *     time_points=["01"],
 *     policy_name="tf-example",
 *     retention_days=1,
 *     repeat_weekdays=["2"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.DatabaseFilesystem.AutoSnapShotPolicy("default", new()
 *     {
 *         TimePoints = new[]
 *         {
 *             "01",
 *         },
 *         PolicyName = "tf-example",
 *         RetentionDays = 1,
 *         RepeatWeekdays = new[]
 *         {
 *             "2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasefilesystem"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databasefilesystem.NewAutoSnapShotPolicy(ctx, "default", &databasefilesystem.AutoSnapShotPolicyArgs{
 * 			TimePoints: pulumi.StringArray{
 * 				pulumi.String("01"),
 * 			},
 * 			PolicyName:    pulumi.String("tf-example"),
 * 			RetentionDays: pulumi.Int(1),
 * 			RepeatWeekdays: pulumi.StringArray{
 * 				pulumi.String("2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.databasefilesystem.AutoSnapShotPolicy;
 * import com.pulumi.alicloud.databasefilesystem.AutoSnapShotPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new AutoSnapShotPolicy("default", AutoSnapShotPolicyArgs.builder()
 *             .timePoints("01")
 *             .policyName("tf-example")
 *             .retentionDays(1)
 *             .repeatWeekdays("2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:databasefilesystem:AutoSnapShotPolicy
 *     properties:
 *       timePoints:
 *         - '01'
 *       policyName: tf-example
 *       retentionDays: 1
 *       repeatWeekdays:
 *         - '2'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Dbfs Auto Snap Shot Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:databasefilesystem/autoSnapShotPolicy:AutoSnapShotPolicy example <id>
 * ```
 */
public class AutoSnapShotPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.databasefilesystem.AutoSnapShotPolicy,
) : KotlinCustomResource(javaResource, AutoSnapShotPolicyMapper) {
    /**
     * The number of database file systems set by the automatic snapshot policy.
     */
    public val appliedDbfsNumber: Output<Int>
        get() = javaResource.appliedDbfsNumber().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Last modification time of automatic snapshot policy
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * Automatic snapshot policy ID
     */
    public val policyId: Output<String>
        get() = javaResource.policyId().applyValue({ args0 -> args0 })

    /**
     * Automatic snapshot policy name
     */
    public val policyName: Output<String>
        get() = javaResource.policyName().applyValue({ args0 -> args0 })

    /**
     * A collection of automatic snapshots performed on several days of the week. Value range: 1~7, for example, `1` means Monday.
     */
    public val repeatWeekdays: Output<List<String>>
        get() = javaResource.repeatWeekdays().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Automatic snapshot retention days.
     */
    public val retentionDays: Output<Int>
        get() = javaResource.retentionDays().applyValue({ args0 -> args0 })

    /**
     * Automatic snapshot policy status
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Automatic snapshot policy status details
     */
    public val statusDetail: Output<String>
        get() = javaResource.statusDetail().applyValue({ args0 -> args0 })

    /**
     * The set of times at which the snapshot is taken on the day the automatic snapshot is executed. Value range: `00` to `23`, representing 24 time points from 00:00 to 23:00, for example, `01` indicates 01:00.
     */
    public val timePoints: Output<List<String>>
        get() = javaResource.timePoints().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object AutoSnapShotPolicyMapper : ResourceMapper<AutoSnapShotPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.databasefilesystem.AutoSnapShotPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AutoSnapShotPolicy = AutoSnapShotPolicy(
        javaResource as
            com.pulumi.alicloud.databasefilesystem.AutoSnapShotPolicy,
    )
}

/**
 * @see [AutoSnapShotPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AutoSnapShotPolicy].
 */
public suspend fun autoSnapShotPolicy(
    name: String,
    block: suspend AutoSnapShotPolicyResourceBuilder.() -> Unit,
): AutoSnapShotPolicy {
    val builder = AutoSnapShotPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AutoSnapShotPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun autoSnapShotPolicy(name: String): AutoSnapShotPolicy {
    val builder = AutoSnapShotPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
