@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin

import com.pulumi.alicloud.databasefilesystem.AutoSnapShotPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Dbfs Auto Snap Shot Policy resource.
 * For information about Dbfs Auto Snap Shot Policy and how to use it.
 * > **NOTE:** Available since v1.202.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.databasefilesystem.AutoSnapShotPolicy("default", {
 *     timePoints: ["01"],
 *     policyName: "tf-example",
 *     retentionDays: 1,
 *     repeatWeekdays: ["2"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.databasefilesystem.AutoSnapShotPolicy("default",
 *     time_points=["01"],
 *     policy_name="tf-example",
 *     retention_days=1,
 *     repeat_weekdays=["2"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.DatabaseFilesystem.AutoSnapShotPolicy("default", new()
 *     {
 *         TimePoints = new[]
 *         {
 *             "01",
 *         },
 *         PolicyName = "tf-example",
 *         RetentionDays = 1,
 *         RepeatWeekdays = new[]
 *         {
 *             "2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasefilesystem"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databasefilesystem.NewAutoSnapShotPolicy(ctx, "default", &databasefilesystem.AutoSnapShotPolicyArgs{
 * 			TimePoints: pulumi.StringArray{
 * 				pulumi.String("01"),
 * 			},
 * 			PolicyName:    pulumi.String("tf-example"),
 * 			RetentionDays: pulumi.Int(1),
 * 			RepeatWeekdays: pulumi.StringArray{
 * 				pulumi.String("2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.databasefilesystem.AutoSnapShotPolicy;
 * import com.pulumi.alicloud.databasefilesystem.AutoSnapShotPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new AutoSnapShotPolicy("default", AutoSnapShotPolicyArgs.builder()
 *             .timePoints("01")
 *             .policyName("tf-example")
 *             .retentionDays(1)
 *             .repeatWeekdays("2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:databasefilesystem:AutoSnapShotPolicy
 *     properties:
 *       timePoints:
 *         - '01'
 *       policyName: tf-example
 *       retentionDays: 1
 *       repeatWeekdays:
 *         - '2'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Dbfs Auto Snap Shot Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:databasefilesystem/autoSnapShotPolicy:AutoSnapShotPolicy example <id>
 * ```
 * @property policyName Automatic snapshot policy name
 * @property repeatWeekdays A collection of automatic snapshots performed on several days of the week. Value range: 1~7, for example, `1` means Monday.
 * @property retentionDays Automatic snapshot retention days.
 * @property timePoints The set of times at which the snapshot is taken on the day the automatic snapshot is executed. Value range: `00` to `23`, representing 24 time points from 00:00 to 23:00, for example, `01` indicates 01:00.
 */
public data class AutoSnapShotPolicyArgs(
    public val policyName: Output<String>? = null,
    public val repeatWeekdays: Output<List<String>>? = null,
    public val retentionDays: Output<Int>? = null,
    public val timePoints: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.databasefilesystem.AutoSnapShotPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.databasefilesystem.AutoSnapShotPolicyArgs =
        com.pulumi.alicloud.databasefilesystem.AutoSnapShotPolicyArgs.builder()
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .repeatWeekdays(repeatWeekdays?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .timePoints(timePoints?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AutoSnapShotPolicyArgs].
 */
@PulumiTagMarker
public class AutoSnapShotPolicyArgsBuilder internal constructor() {
    private var policyName: Output<String>? = null

    private var repeatWeekdays: Output<List<String>>? = null

    private var retentionDays: Output<Int>? = null

    private var timePoints: Output<List<String>>? = null

    /**
     * @param value Automatic snapshot policy name
     */
    @JvmName("xmwqeygwebuitbwo")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value A collection of automatic snapshots performed on several days of the week. Value range: 1~7, for example, `1` means Monday.
     */
    @JvmName("uprrcpbfjpbwqprk")
    public suspend fun repeatWeekdays(`value`: Output<List<String>>) {
        this.repeatWeekdays = value
    }

    @JvmName("rgebxuciabdpgpey")
    public suspend fun repeatWeekdays(vararg values: Output<String>) {
        this.repeatWeekdays = Output.all(values.asList())
    }

    /**
     * @param values A collection of automatic snapshots performed on several days of the week. Value range: 1~7, for example, `1` means Monday.
     */
    @JvmName("mbmhipgdhaopnsdd")
    public suspend fun repeatWeekdays(values: List<Output<String>>) {
        this.repeatWeekdays = Output.all(values)
    }

    /**
     * @param value Automatic snapshot retention days.
     */
    @JvmName("pbbnnyceuvcrqcjt")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value The set of times at which the snapshot is taken on the day the automatic snapshot is executed. Value range: `00` to `23`, representing 24 time points from 00:00 to 23:00, for example, `01` indicates 01:00.
     */
    @JvmName("ksfuyuibusnrrdai")
    public suspend fun timePoints(`value`: Output<List<String>>) {
        this.timePoints = value
    }

    @JvmName("aekslrookobsqdpg")
    public suspend fun timePoints(vararg values: Output<String>) {
        this.timePoints = Output.all(values.asList())
    }

    /**
     * @param values The set of times at which the snapshot is taken on the day the automatic snapshot is executed. Value range: `00` to `23`, representing 24 time points from 00:00 to 23:00, for example, `01` indicates 01:00.
     */
    @JvmName("pkduamnqcfkaqwgu")
    public suspend fun timePoints(values: List<Output<String>>) {
        this.timePoints = Output.all(values)
    }

    /**
     * @param value Automatic snapshot policy name
     */
    @JvmName("entkmrphighelfdd")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value A collection of automatic snapshots performed on several days of the week. Value range: 1~7, for example, `1` means Monday.
     */
    @JvmName("fkjgcukscdomhkxp")
    public suspend fun repeatWeekdays(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repeatWeekdays = mapped
    }

    /**
     * @param values A collection of automatic snapshots performed on several days of the week. Value range: 1~7, for example, `1` means Monday.
     */
    @JvmName("pygbsgdakmesbuao")
    public suspend fun repeatWeekdays(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repeatWeekdays = mapped
    }

    /**
     * @param value Automatic snapshot retention days.
     */
    @JvmName("fibsncwvctenrjua")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value The set of times at which the snapshot is taken on the day the automatic snapshot is executed. Value range: `00` to `23`, representing 24 time points from 00:00 to 23:00, for example, `01` indicates 01:00.
     */
    @JvmName("oqrmuxtljuvenjbj")
    public suspend fun timePoints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timePoints = mapped
    }

    /**
     * @param values The set of times at which the snapshot is taken on the day the automatic snapshot is executed. Value range: `00` to `23`, representing 24 time points from 00:00 to 23:00, for example, `01` indicates 01:00.
     */
    @JvmName("amojhqmsasrulpfu")
    public suspend fun timePoints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timePoints = mapped
    }

    internal fun build(): AutoSnapShotPolicyArgs = AutoSnapShotPolicyArgs(
        policyName = policyName,
        repeatWeekdays = repeatWeekdays,
        retentionDays = retentionDays,
        timePoints = timePoints,
    )
}
