@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin

import com.pulumi.alicloud.databasefilesystem.DatabasefilesystemFunctions.getAutoSnapShotPoliciesPlain
import com.pulumi.alicloud.databasefilesystem.DatabasefilesystemFunctions.getInstancesPlain
import com.pulumi.alicloud.databasefilesystem.DatabasefilesystemFunctions.getSnapshotsPlain
import com.pulumi.alicloud.databasefilesystem.kotlin.inputs.GetAutoSnapShotPoliciesPlainArgs
import com.pulumi.alicloud.databasefilesystem.kotlin.inputs.GetAutoSnapShotPoliciesPlainArgsBuilder
import com.pulumi.alicloud.databasefilesystem.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.databasefilesystem.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.databasefilesystem.kotlin.inputs.GetSnapshotsPlainArgs
import com.pulumi.alicloud.databasefilesystem.kotlin.inputs.GetSnapshotsPlainArgsBuilder
import com.pulumi.alicloud.databasefilesystem.kotlin.outputs.GetAutoSnapShotPoliciesResult
import com.pulumi.alicloud.databasefilesystem.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.databasefilesystem.kotlin.outputs.GetSnapshotsResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.databasefilesystem.kotlin.outputs.GetAutoSnapShotPoliciesResult.Companion.toKotlin as getAutoSnapShotPoliciesResultToKotlin
import com.pulumi.alicloud.databasefilesystem.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.databasefilesystem.kotlin.outputs.GetSnapshotsResult.Companion.toKotlin as getSnapshotsResultToKotlin

public object DatabasefilesystemFunctions {
    /**
     * This data source provides Dbfs Auto Snap Shot Policy available to the user.[What is Auto Snap Shot Policy](https://help.aliyun.com/document_detail/469597.html)
     * > **NOTE:** Available in 1.202.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.databasefilesystem.getAutoSnapShotPolicies({
     *     ids: [defaultAlicloudDbfsAutoSnapShotPolicy&#46;id],
     * });
     * export const alicloudDbfsAutoSnapShotPolicyExampleId = _default.then(_default => _default.autoSnapShotPolicies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.databasefilesystem.get_auto_snap_shot_policies(ids=[default_alicloud_dbfs_auto_snap_shot_policy["id"]])
     * pulumi.export("alicloudDbfsAutoSnapShotPolicyExampleId", default.auto_snap_shot_policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.DatabaseFilesystem.GetAutoSnapShotPolicies.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudDbfsAutoSnapShotPolicy.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudDbfsAutoSnapShotPolicyExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getAutoSnapShotPoliciesResult => getAutoSnapShotPoliciesResult&#46;AutoSnapShotPolicies[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasefilesystem"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := databasefilesystem.GetAutoSnapShotPolicies(ctx, &databasefilesystem.GetAutoSnapShotPoliciesArgs{
     * Ids: interface{}{
     * defaultAlicloudDbfsAutoSnapShotPolicy.Id,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudDbfsAutoSnapShotPolicyExampleId", _default.AutoSnapShotPolicies[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.databasefilesystem.DatabasefilesystemFunctions;
     * import com.pulumi.alicloud.databasefilesystem.inputs.GetAutoSnapShotPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = DatabasefilesystemFunctions.getAutoSnapShotPolicies(GetAutoSnapShotPoliciesArgs.builder()
     *             .ids(defaultAlicloudDbfsAutoSnapShotPolicy.id())
     *             .build());
     *         ctx.export("alicloudDbfsAutoSnapShotPolicyExampleId", default_.autoSnapShotPolicies()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:databasefilesystem:getAutoSnapShotPolicies
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudDbfsAutoSnapShotPolicy.id}
     * outputs:
     *   alicloudDbfsAutoSnapShotPolicyExampleId: ${default.autoSnapShotPolicies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAutoSnapShotPolicies.
     * @return A collection of values returned by getAutoSnapShotPolicies.
     */
    public suspend fun getAutoSnapShotPolicies(argument: GetAutoSnapShotPoliciesPlainArgs): GetAutoSnapShotPoliciesResult =
        getAutoSnapShotPoliciesResultToKotlin(getAutoSnapShotPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getAutoSnapShotPolicies].
     * @param ids A list of Auto Snap Shot Policy IDs.
     * @param nameRegex A regex string to filter results by Auto Snap Shot Policy name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getAutoSnapShotPolicies.
     */
    public suspend fun getAutoSnapShotPolicies(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetAutoSnapShotPoliciesResult {
        val argument = GetAutoSnapShotPoliciesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getAutoSnapShotPoliciesResultToKotlin(getAutoSnapShotPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAutoSnapShotPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;databasefilesystem&#46;kotlin&#46;inputs&#46;GetAutoSnapShotPoliciesPlainArgs].
     * @return A collection of values returned by getAutoSnapShotPolicies.
     */
    public suspend fun getAutoSnapShotPolicies(argument: suspend GetAutoSnapShotPoliciesPlainArgsBuilder.() -> Unit): GetAutoSnapShotPoliciesResult {
        val builder = GetAutoSnapShotPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAutoSnapShotPoliciesResultToKotlin(getAutoSnapShotPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the DBFS Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.136.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.databasefilesystem.getInstances({
     *     ids: ["example_id"],
     * });
     * export const dbfsInstanceId1 = ids.then(ids => ids.instances?.[0]?.id);
     * const nameRegex = alicloud.databasefilesystem.getInstances({
     *     nameRegex: "^my-Instance",
     * });
     * export const dbfsInstanceId2 = nameRegex.then(nameRegex => nameRegex.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.databasefilesystem.get_instances(ids=["example_id"])
     * pulumi.export("dbfsInstanceId1", ids.instances[0].id)
     * name_regex = alicloud.databasefilesystem.get_instances(name_regex="^my-Instance")
     * pulumi.export("dbfsInstanceId2", name_regex.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.DatabaseFilesystem.GetInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.DatabaseFilesystem.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "^my-Instance",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["dbfsInstanceId1"] = ids&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *         ["dbfsInstanceId2"] = nameRegex&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasefilesystem"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := databasefilesystem.GetInstances(ctx, &databasefilesystem.GetInstancesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dbfsInstanceId1", ids.Instances[0].Id)
     * 		nameRegex, err := databasefilesystem.GetInstances(ctx, &databasefilesystem.GetInstancesArgs{
     * 			NameRegex: pulumi.StringRef("^my-Instance"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dbfsInstanceId2", nameRegex.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.databasefilesystem.DatabasefilesystemFunctions;
     * import com.pulumi.alicloud.databasefilesystem.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DatabasefilesystemFunctions.getInstances(GetInstancesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("dbfsInstanceId1", ids.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *         final var nameRegex = DatabasefilesystemFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("^my-Instance")
     *             .build());
     *         ctx.export("dbfsInstanceId2", nameRegex.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:databasefilesystem:getInstances
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:databasefilesystem:getInstances
     *       Arguments:
     *         nameRegex: ^my-Instance
     * outputs:
     *   dbfsInstanceId1: ${ids.instances[0].id}
     *   dbfsInstanceId2: ${nameRegex.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param ids A list of Instance IDs.
     * @param nameRegex A regex string to filter results by Instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status Database file system state. Valid values: `attached`, `attaching`, `creating`, `deleted`, `deleting`, `detaching`, `resizing`, `snapshotting`, `unattached`, `upgrading`.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;databasefilesystem&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Dbfs Snapshots of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.156.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.databasefilesystem.getSnapshots({
     *     ids: ["example_id"],
     * });
     * export const dbfsSnapshotId1 = ids.then(ids => ids.snapshots?.[0]?.id);
     * const nameRegex = alicloud.databasefilesystem.getSnapshots({
     *     nameRegex: "^my-Snapshot",
     * });
     * export const dbfsSnapshotId2 = nameRegex.then(nameRegex => nameRegex.snapshots?.[0]?.id);
     * const status = alicloud.databasefilesystem.getSnapshots({
     *     status: "accomplished",
     * });
     * export const dbfsSnapshotId3 = status.then(status => status.snapshots?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.databasefilesystem.get_snapshots(ids=["example_id"])
     * pulumi.export("dbfsSnapshotId1", ids.snapshots[0].id)
     * name_regex = alicloud.databasefilesystem.get_snapshots(name_regex="^my-Snapshot")
     * pulumi.export("dbfsSnapshotId2", name_regex.snapshots[0].id)
     * status = alicloud.databasefilesystem.get_snapshots(status="accomplished")
     * pulumi.export("dbfsSnapshotId3", status.snapshots[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.DatabaseFilesystem.GetSnapshots.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.DatabaseFilesystem.GetSnapshots.Invoke(new()
     *     {
     *         NameRegex = "^my-Snapshot",
     *     });
     *     var status = AliCloud.DatabaseFilesystem.GetSnapshots.Invoke(new()
     *     {
     *         Status = "accomplished",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["dbfsSnapshotId1"] = ids&#46;Apply(getSnapshotsResult => getSnapshotsResult&#46;Snapshots[0]?.Id),
     *         ["dbfsSnapshotId2"] = nameRegex&#46;Apply(getSnapshotsResult => getSnapshotsResult&#46;Snapshots[0]?.Id),
     *         ["dbfsSnapshotId3"] = status&#46;Apply(getSnapshotsResult => getSnapshotsResult&#46;Snapshots[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasefilesystem"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := databasefilesystem.GetSnapshots(ctx, &databasefilesystem.GetSnapshotsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dbfsSnapshotId1", ids.Snapshots[0].Id)
     * 		nameRegex, err := databasefilesystem.GetSnapshots(ctx, &databasefilesystem.GetSnapshotsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Snapshot"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dbfsSnapshotId2", nameRegex.Snapshots[0].Id)
     * 		status, err := databasefilesystem.GetSnapshots(ctx, &databasefilesystem.GetSnapshotsArgs{
     * 			Status: pulumi.StringRef("accomplished"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dbfsSnapshotId3", status.Snapshots[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.databasefilesystem.DatabasefilesystemFunctions;
     * import com.pulumi.alicloud.databasefilesystem.inputs.GetSnapshotsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DatabasefilesystemFunctions.getSnapshots(GetSnapshotsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("dbfsSnapshotId1", ids.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].id()));
     *         final var nameRegex = DatabasefilesystemFunctions.getSnapshots(GetSnapshotsArgs.builder()
     *             .nameRegex("^my-Snapshot")
     *             .build());
     *         ctx.export("dbfsSnapshotId2", nameRegex.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].id()));
     *         final var status = DatabasefilesystemFunctions.getSnapshots(GetSnapshotsArgs.builder()
     *             .status("accomplished")
     *             .build());
     *         ctx.export("dbfsSnapshotId3", status.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:databasefilesystem:getSnapshots
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:databasefilesystem:getSnapshots
     *       Arguments:
     *         nameRegex: ^my-Snapshot
     *   status:
     *     fn::invoke:
     *       Function: alicloud:databasefilesystem:getSnapshots
     *       Arguments:
     *         status: accomplished
     * outputs:
     *   dbfsSnapshotId1: ${ids.snapshots[0].id}
     *   dbfsSnapshotId2: ${nameRegex.snapshots[0].id}
     *   dbfsSnapshotId3: ${status.snapshots[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSnapshots.
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(argument: GetSnapshotsPlainArgs): GetSnapshotsResult =
        getSnapshotsResultToKotlin(getSnapshotsPlain(argument.toJava()).await())

    /**
     * @see [getSnapshots].
     * @param ids A list of Snapshot IDs.
     * @param nameRegex A regex string to filter results by Snapshot name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the snapshot. Valid values: `accomplished`, `failed`, `progressing`.
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetSnapshotsResult {
        val argument = GetSnapshotsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getSnapshotsResultToKotlin(getSnapshotsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshots].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;databasefilesystem&#46;kotlin&#46;inputs&#46;GetSnapshotsPlainArgs].
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(argument: suspend GetSnapshotsPlainArgsBuilder.() -> Unit): GetSnapshotsResult {
        val builder = GetSnapshotsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotsResultToKotlin(getSnapshotsPlain(builtArgument.toJava()).await())
    }
}
