@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin

import com.pulumi.alicloud.databasefilesystem.kotlin.outputs.InstanceEcsList
import com.pulumi.alicloud.databasefilesystem.kotlin.outputs.InstanceEcsList.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.databasefilesystem.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a DBFS Dbfs Instance resource. An instance of a database file system is equivalent to a file system and can store data of file types.
 * For information about DBFS Dbfs Instance and how to use it, see [What is Dbfs Instance](https://next.api.alibabacloud.com/document/DBFS/2020-04-18/CreateDbfs).
 * > **NOTE:** Available since v1.136.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const example = new alicloud.databasefilesystem.Instance("example", {
 *     category: "standard",
 *     zoneId: "cn-hangzhou-i",
 *     performanceLevel: "PL1",
 *     instanceName: name,
 *     size: 100,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * example = alicloud.databasefilesystem.Instance("example",
 *     category="standard",
 *     zone_id="cn-hangzhou-i",
 *     performance_level="PL1",
 *     instance_name=name,
 *     size=100)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var example = new AliCloud.DatabaseFilesystem.Instance("example", new()
 *     {
 *         Category = "standard",
 *         ZoneId = "cn-hangzhou-i",
 *         PerformanceLevel = "PL1",
 *         InstanceName = name,
 *         Size = 100,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasefilesystem"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := databasefilesystem.NewInstance(ctx, "example", &databasefilesystem.InstanceArgs{
 * 			Category:         pulumi.String("standard"),
 * 			ZoneId:           pulumi.String("cn-hangzhou-i"),
 * 			PerformanceLevel: pulumi.String("PL1"),
 * 			InstanceName:     pulumi.String(name),
 * 			Size:             pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.databasefilesystem.Instance;
 * import com.pulumi.alicloud.databasefilesystem.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .category("standard")
 *             .zoneId("cn-hangzhou-i")
 *             .performanceLevel("PL1")
 *             .instanceName(name)
 *             .size(100)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   example:
 *     type: alicloud:databasefilesystem:Instance
 *     properties:
 *       category: standard
 *       zoneId: cn-hangzhou-i
 *       performanceLevel: PL1
 *       instanceName: ${name}
 *       size: 100
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DBFS Dbfs Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:databasefilesystem/instance:Instance example <id>
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.databasefilesystem.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * The number of CPU cores and the upper limit of memory used by the database file storage instance.
     */
    public val advancedFeatures: Output<String>
        get() = javaResource.advancedFeatures().applyValue({ args0 -> args0 })

    /**
     * Category of database file system.
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Whether to delete the original snapshot after creating DBFS using the snapshot.
     */
    public val deleteSnapshot: Output<Boolean>?
        get() = javaResource.deleteSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
     */
    @Deprecated(
        message = """
  Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS
      and DBFS.
  """,
    )
    public val ecsLists: Output<List<InstanceEcsList>>?
        get() = javaResource.ecsLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Whether to create DBFS in RAID mode. If created in RAID mode, the capacity is at least 66GB.Valid values: true or false. Default value: false.
     */
    public val enableRaid: Output<Boolean>?
        get() = javaResource.enableRaid().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to encrypt DBFS.Valid values: true or false. Default value: false.
     */
    public val encryption: Output<Boolean>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Database file system name.
     */
    public val fsName: Output<String>
        get() = javaResource.fsName().applyValue({ args0 -> args0 })

    @Deprecated(
        message = """
  Field 'instance_name' has been deprecated since provider version 1.212.0. New field 'fs_name'
      instead.
  """,
    )
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * Instance type. Value range:
     * - dbfs.small
     * - dbfs.medium
     * - dbfs.large (default)
     */
    public val instanceType: Output<String>?
        get() = javaResource.instanceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the KMS key used by DBFS.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * When you create a DBFS instance, set the performance level of the DBFS instance. Value range:
     * - PL0: single disk maximum random read-write IOPS 10000
     * - PL1: highest random read-write IOPS 50000 per disk (default)
     * - PL2: single disk maximum random read-write IOPS 100000
     * - PL3: single disk maximum random read-write IOPS 1 million.
     */
    public val performanceLevel: Output<String>
        get() = javaResource.performanceLevel().applyValue({ args0 -> args0 })

    /**
     * Number of strips. Required when the EnableRaid parameter is true.Value range: Currently, only 8 stripes are supported.
     */
    public val raidStripeUnitNumber: Output<Int>?
        get() = javaResource.raidStripeUnitNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Size of database file system, unit GiB.
     */
    public val size: Output<Int>
        get() = javaResource.size().applyValue({ args0 -> args0 })

    /**
     * The ID of the snapshot used to create the DBFS instance.
     */
    public val snapshotId: Output<String>
        get() = javaResource.snapshotId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The usage scenario of DBFS. Value range:
     * - MySQL 5.7
     * - PostgreSQL
     * - MongoDB.
     */
    public val usedScene: Output<String>?
        get() = javaResource.usedScene().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the zone to which the database file system belongs.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.databasefilesystem.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.databasefilesystem.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
