@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin

import com.pulumi.alicloud.databasefilesystem.InstanceArgs.builder
import com.pulumi.alicloud.databasefilesystem.kotlin.inputs.InstanceEcsListArgs
import com.pulumi.alicloud.databasefilesystem.kotlin.inputs.InstanceEcsListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DBFS Dbfs Instance resource. An instance of a database file system is equivalent to a file system and can store data of file types.
 * For information about DBFS Dbfs Instance and how to use it, see [What is Dbfs Instance](https://next.api.alibabacloud.com/document/DBFS/2020-04-18/CreateDbfs).
 * > **NOTE:** Available since v1.136.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const example = new alicloud.databasefilesystem.Instance("example", {
 *     category: "standard",
 *     zoneId: "cn-hangzhou-i",
 *     performanceLevel: "PL1",
 *     instanceName: name,
 *     size: 100,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * example = alicloud.databasefilesystem.Instance("example",
 *     category="standard",
 *     zone_id="cn-hangzhou-i",
 *     performance_level="PL1",
 *     instance_name=name,
 *     size=100)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var example = new AliCloud.DatabaseFilesystem.Instance("example", new()
 *     {
 *         Category = "standard",
 *         ZoneId = "cn-hangzhou-i",
 *         PerformanceLevel = "PL1",
 *         InstanceName = name,
 *         Size = 100,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasefilesystem"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := databasefilesystem.NewInstance(ctx, "example", &databasefilesystem.InstanceArgs{
 * 			Category:         pulumi.String("standard"),
 * 			ZoneId:           pulumi.String("cn-hangzhou-i"),
 * 			PerformanceLevel: pulumi.String("PL1"),
 * 			InstanceName:     pulumi.String(name),
 * 			Size:             pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.databasefilesystem.Instance;
 * import com.pulumi.alicloud.databasefilesystem.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .category("standard")
 *             .zoneId("cn-hangzhou-i")
 *             .performanceLevel("PL1")
 *             .instanceName(name)
 *             .size(100)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   example:
 *     type: alicloud:databasefilesystem:Instance
 *     properties:
 *       category: standard
 *       zoneId: cn-hangzhou-i
 *       performanceLevel: PL1
 *       instanceName: ${name}
 *       size: 100
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DBFS Dbfs Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:databasefilesystem/instance:Instance example <id>
 * ```
 * @property advancedFeatures The number of CPU cores and the upper limit of memory used by the database file storage instance.
 * @property category Category of database file system.
 * @property deleteSnapshot Whether to delete the original snapshot after creating DBFS using the snapshot.
 * @property ecsLists The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
 * @property enableRaid Whether to create DBFS in RAID mode. If created in RAID mode, the capacity is at least 66GB.Valid values: true or false. Default value: false.
 * @property encryption Whether to encrypt DBFS.Valid values: true or false. Default value: false.
 * @property fsName Database file system name.
 * @property instanceName
 * @property instanceType Instance type. Value range:
 * - dbfs.small
 * - dbfs.medium
 * - dbfs.large (default)
 * @property kmsKeyId The ID of the KMS key used by DBFS.
 * @property performanceLevel When you create a DBFS instance, set the performance level of the DBFS instance. Value range:
 * - PL0: single disk maximum random read-write IOPS 10000
 * - PL1: highest random read-write IOPS 50000 per disk (default)
 * - PL2: single disk maximum random read-write IOPS 100000
 * - PL3: single disk maximum random read-write IOPS 1 million.
 * @property raidStripeUnitNumber Number of strips. Required when the EnableRaid parameter is true.Value range: Currently, only 8 stripes are supported.
 * @property size Size of database file system, unit GiB.
 * @property snapshotId The ID of the snapshot used to create the DBFS instance.
 * @property tags A mapping of tags to assign to the resource.
 * @property usedScene The usage scenario of DBFS. Value range:
 * - MySQL 5.7
 * - PostgreSQL
 * - MongoDB.
 * @property zoneId The ID of the zone to which the database file system belongs.
 */
public data class InstanceArgs(
    public val advancedFeatures: Output<String>? = null,
    public val category: Output<String>? = null,
    public val deleteSnapshot: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS
      and DBFS.
  """,
    )
    public val ecsLists: Output<List<InstanceEcsListArgs>>? = null,
    public val enableRaid: Output<Boolean>? = null,
    public val encryption: Output<Boolean>? = null,
    public val fsName: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'instance_name' has been deprecated since provider version 1.212.0. New field 'fs_name'
      instead.
  """,
    )
    public val instanceName: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
    public val raidStripeUnitNumber: Output<Int>? = null,
    public val size: Output<Int>? = null,
    public val snapshotId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val usedScene: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.databasefilesystem.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.databasefilesystem.InstanceArgs =
        com.pulumi.alicloud.databasefilesystem.InstanceArgs.builder()
            .advancedFeatures(advancedFeatures?.applyValue({ args0 -> args0 }))
            .category(category?.applyValue({ args0 -> args0 }))
            .deleteSnapshot(deleteSnapshot?.applyValue({ args0 -> args0 }))
            .ecsLists(
                ecsLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableRaid(enableRaid?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0 }))
            .fsName(fsName?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .raidStripeUnitNumber(raidStripeUnitNumber?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .usedScene(usedScene?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var advancedFeatures: Output<String>? = null

    private var category: Output<String>? = null

    private var deleteSnapshot: Output<Boolean>? = null

    private var ecsLists: Output<List<InstanceEcsListArgs>>? = null

    private var enableRaid: Output<Boolean>? = null

    private var encryption: Output<Boolean>? = null

    private var fsName: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    private var raidStripeUnitNumber: Output<Int>? = null

    private var size: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var usedScene: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The number of CPU cores and the upper limit of memory used by the database file storage instance.
     */
    @JvmName("vhfwwncrjnuaoguo")
    public suspend fun advancedFeatures(`value`: Output<String>) {
        this.advancedFeatures = value
    }

    /**
     * @param value Category of database file system.
     */
    @JvmName("lrfdfgivtdmqjapd")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Whether to delete the original snapshot after creating DBFS using the snapshot.
     */
    @JvmName("nxulntsrdsydciun")
    public suspend fun deleteSnapshot(`value`: Output<Boolean>) {
        this.deleteSnapshot = value
    }

    /**
     * @param value The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
     */
    @Deprecated(
        message = """
  Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS
      and DBFS.
  """,
    )
    @JvmName("thhtcmdfgdjgoeac")
    public suspend fun ecsLists(`value`: Output<List<InstanceEcsListArgs>>) {
        this.ecsLists = value
    }

    @JvmName("eqqosqvxihvvcwue")
    public suspend fun ecsLists(vararg values: Output<InstanceEcsListArgs>) {
        this.ecsLists = Output.all(values.asList())
    }

    /**
     * @param values The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
     */
    @Deprecated(
        message = """
  Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS
      and DBFS.
  """,
    )
    @JvmName("ddbmyiopabiamaqr")
    public suspend fun ecsLists(values: List<Output<InstanceEcsListArgs>>) {
        this.ecsLists = Output.all(values)
    }

    /**
     * @param value Whether to create DBFS in RAID mode. If created in RAID mode, the capacity is at least 66GB.Valid values: true or false. Default value: false.
     */
    @JvmName("hbmtcpahvuhvrpjx")
    public suspend fun enableRaid(`value`: Output<Boolean>) {
        this.enableRaid = value
    }

    /**
     * @param value Whether to encrypt DBFS.Valid values: true or false. Default value: false.
     */
    @JvmName("jmmhkuwokmchdbmk")
    public suspend fun encryption(`value`: Output<Boolean>) {
        this.encryption = value
    }

    /**
     * @param value Database file system name.
     */
    @JvmName("mugnxcvvwsgmberk")
    public suspend fun fsName(`value`: Output<String>) {
        this.fsName = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'instance_name' has been deprecated since provider version 1.212.0. New field 'fs_name'
      instead.
  """,
    )
    @JvmName("ryexsxgpnaibmkkj")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Instance type. Value range:
     * - dbfs.small
     * - dbfs.medium
     * - dbfs.large (default)
     */
    @JvmName("bueyownevebnlxnd")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The ID of the KMS key used by DBFS.
     */
    @JvmName("luejdxfckmrgbfkn")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value When you create a DBFS instance, set the performance level of the DBFS instance. Value range:
     * - PL0: single disk maximum random read-write IOPS 10000
     * - PL1: highest random read-write IOPS 50000 per disk (default)
     * - PL2: single disk maximum random read-write IOPS 100000
     * - PL3: single disk maximum random read-write IOPS 1 million.
     */
    @JvmName("hqxrrvqnyxaoaphv")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value Number of strips. Required when the EnableRaid parameter is true.Value range: Currently, only 8 stripes are supported.
     */
    @JvmName("vnerkkcfdnxdgyoy")
    public suspend fun raidStripeUnitNumber(`value`: Output<Int>) {
        this.raidStripeUnitNumber = value
    }

    /**
     * @param value Size of database file system, unit GiB.
     */
    @JvmName("dajblniywwbgiusr")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The ID of the snapshot used to create the DBFS instance.
     */
    @JvmName("fhmkltntdsxvfedj")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("eleyxilawpcjbecb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The usage scenario of DBFS. Value range:
     * - MySQL 5.7
     * - PostgreSQL
     * - MongoDB.
     */
    @JvmName("gbbkiqfiftmdlvpx")
    public suspend fun usedScene(`value`: Output<String>) {
        this.usedScene = value
    }

    /**
     * @param value The ID of the zone to which the database file system belongs.
     */
    @JvmName("tdeikpcxykfrkiek")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The number of CPU cores and the upper limit of memory used by the database file storage instance.
     */
    @JvmName("hciddyxlyxrxrdbw")
    public suspend fun advancedFeatures(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedFeatures = mapped
    }

    /**
     * @param value Category of database file system.
     */
    @JvmName("ltgppbpupplueues")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Whether to delete the original snapshot after creating DBFS using the snapshot.
     */
    @JvmName("jxrfehltxbkablnn")
    public suspend fun deleteSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteSnapshot = mapped
    }

    /**
     * @param value The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
     */
    @Deprecated(
        message = """
  Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS
      and DBFS.
  """,
    )
    @JvmName("easspfwsccecasmx")
    public suspend fun ecsLists(`value`: List<InstanceEcsListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsLists = mapped
    }

    /**
     * @param argument The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
     */
    @Deprecated(
        message = """
  Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS
      and DBFS.
  """,
    )
    @JvmName("xhkchevncenxtumo")
    public suspend fun ecsLists(argument: List<suspend InstanceEcsListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceEcsListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ecsLists = mapped
    }

    /**
     * @param argument The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
     */
    @Deprecated(
        message = """
  Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS
      and DBFS.
  """,
    )
    @JvmName("vnjfaqnexwqskijn")
    public suspend fun ecsLists(vararg argument: suspend InstanceEcsListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceEcsListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ecsLists = mapped
    }

    /**
     * @param argument The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
     */
    @Deprecated(
        message = """
  Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS
      and DBFS.
  """,
    )
    @JvmName("chfnoctnfcnqauqk")
    public suspend fun ecsLists(argument: suspend InstanceEcsListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceEcsListArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ecsLists = mapped
    }

    /**
     * @param values The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
     */
    @Deprecated(
        message = """
  Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS
      and DBFS.
  """,
    )
    @JvmName("adfnofgkfuqhchyt")
    public suspend fun ecsLists(vararg values: InstanceEcsListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ecsLists = mapped
    }

    /**
     * @param value Whether to create DBFS in RAID mode. If created in RAID mode, the capacity is at least 66GB.Valid values: true or false. Default value: false.
     */
    @JvmName("mcsbrwyriambjsxe")
    public suspend fun enableRaid(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRaid = mapped
    }

    /**
     * @param value Whether to encrypt DBFS.Valid values: true or false. Default value: false.
     */
    @JvmName("qiigysuasvupwpij")
    public suspend fun encryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param value Database file system name.
     */
    @JvmName("wuphpgclswhpgarc")
    public suspend fun fsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsName = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'instance_name' has been deprecated since provider version 1.212.0. New field 'fs_name'
      instead.
  """,
    )
    @JvmName("iesoimmhgiapibjq")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Instance type. Value range:
     * - dbfs.small
     * - dbfs.medium
     * - dbfs.large (default)
     */
    @JvmName("evglqcihwblkjkaa")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The ID of the KMS key used by DBFS.
     */
    @JvmName("kyeihmghnxdldlav")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value When you create a DBFS instance, set the performance level of the DBFS instance. Value range:
     * - PL0: single disk maximum random read-write IOPS 10000
     * - PL1: highest random read-write IOPS 50000 per disk (default)
     * - PL2: single disk maximum random read-write IOPS 100000
     * - PL3: single disk maximum random read-write IOPS 1 million.
     */
    @JvmName("ismrbnwauvycxufm")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value Number of strips. Required when the EnableRaid parameter is true.Value range: Currently, only 8 stripes are supported.
     */
    @JvmName("htjswgwywhecnpaf")
    public suspend fun raidStripeUnitNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raidStripeUnitNumber = mapped
    }

    /**
     * @param value Size of database file system, unit GiB.
     */
    @JvmName("eettphbejiigslru")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The ID of the snapshot used to create the DBFS instance.
     */
    @JvmName("ulkryfbqhyvrhdto")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("nrnrymljnxfxcjec")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("eappjbdercurbxcd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The usage scenario of DBFS. Value range:
     * - MySQL 5.7
     * - PostgreSQL
     * - MongoDB.
     */
    @JvmName("hkcqosxbmfaqaebd")
    public suspend fun usedScene(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usedScene = mapped
    }

    /**
     * @param value The ID of the zone to which the database file system belongs.
     */
    @JvmName("qrhllpehaayjuwyy")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        advancedFeatures = advancedFeatures,
        category = category,
        deleteSnapshot = deleteSnapshot,
        ecsLists = ecsLists,
        enableRaid = enableRaid,
        encryption = encryption,
        fsName = fsName,
        instanceName = instanceName,
        instanceType = instanceType,
        kmsKeyId = kmsKeyId,
        performanceLevel = performanceLevel,
        raidStripeUnitNumber = raidStripeUnitNumber,
        size = size,
        snapshotId = snapshotId,
        tags = tags,
        usedScene = usedScene,
        zoneId = zoneId,
    )
}
