@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin

import com.pulumi.alicloud.databasefilesystem.InstanceAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DBFS Instance Attachment resource.
 * For information about DBFS Instance Attachment and how to use it.
 * > **NOTE:** Available since v1.156.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const zoneId = "cn-hangzhou-i";
 * const example = alicloud.ecs.getInstanceTypes({
 *     availabilityZone: zoneId,
 *     instanceTypeFamily: "ecs.g7se",
 * });
 * const exampleGetImages = Promise.all([example, example&#46;then(example => example&#46;instanceTypes)&#46;length])&#46;then(([example, length]) => alicloud.ecs.getImages({
 *     instanceType: example.instanceTypes[length - 1].id,
 *     nameRegex: "^aliyun_2_1903_x64_20G_alibase_20240628.vhd",
 *     owners: "system",
 * }));
 * const default = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = _default.then(_default => alicloud.vpc.getSwitches({
 *     vpcId: _default.ids?.[0],
 *     zoneId: zoneId,
 * }));
 * const exampleSecurityGroup = new alicloud.ecs.SecurityGroup("example", {
 *     name: name,
 *     vpcId: _default.then(_default => _default.ids?.[0]),
 * });
 * const defaultInstance = new alicloud.ecs.Instance("default", {
 *     availabilityZone: zoneId,
 *     instanceName: name,
 *     imageId: exampleGetImages.then(exampleGetImages => exampleGetImages.images?.[0]?.id),
 *     instanceType: Promise.all([example, example&#46;then(example => example&#46;instanceTypes)&#46;length])&#46;then(([example, length]) => example&#46;instanceTypes[length - 1].id),
 *     securityGroups: [exampleSecurityGroup&#46;id],
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     systemDiskCategory: "cloud_essd",
 * });
 * const defaultInstance2 = new alicloud.databasefilesystem.Instance("default", {
 *     category: "enterprise",
 *     zoneId: defaultInstance.availabilityZone,
 *     performanceLevel: "PL1",
 *     fsName: name,
 *     size: 100,
 * });
 * const exampleInstanceAttachment = new alicloud.databasefilesystem.InstanceAttachment("example", {
 *     ecsId: defaultInstance.id,
 *     instanceId: defaultInstance2.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * zone_id = "cn-hangzhou-i"
 * example = alicloud.ecs.get_instance_types(availability_zone=zone_id,
 *     instance_type_family="ecs.g7se")
 * example_get_images = alicloud.ecs.get_images(instance_type=example.instance_types[len(example&#46;instance_types) - 1].id,
 *     name_regex="^aliyun_2_1903_x64_20G_alibase_20240628.vhd",
 *     owners="system")
 * default = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default.ids[0],
 *     zone_id=zone_id)
 * example_security_group = alicloud.ecs.SecurityGroup("example",
 *     name=name,
 *     vpc_id=default.ids[0])
 * default_instance = alicloud.ecs.Instance("default",
 *     availability_zone=zone_id,
 *     instance_name=name,
 *     image_id=example_get_images.images[0].id,
 *     instance_type=example.instance_types[len(example&#46;instance_types) - 1].id,
 *     security_groups=[example_security_group&#46;id],
 *     vswitch_id=default_get_switches.ids[0],
 *     system_disk_category="cloud_essd")
 * default_instance2 = alicloud.databasefilesystem.Instance("default",
 *     category="enterprise",
 *     zone_id=default_instance.availability_zone,
 *     performance_level="PL1",
 *     fs_name=name,
 *     size=100)
 * example_instance_attachment = alicloud.databasefilesystem.InstanceAttachment("example",
 *     ecs_id=default_instance.id,
 *     instance_id=default_instance2.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var zoneId = "cn-hangzhou-i";
 *     var example = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = zoneId,
 *         InstanceTypeFamily = "ecs.g7se",
 *     });
 *     var exampleGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         InstanceType = example.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes)[example&#46;Apply(getInstanceTypesResult => getInstanceTypesResult&#46;InstanceTypes)&#46;Length - 1].Id,
 *         NameRegex = "^aliyun_2_1903_x64_20G_alibase_20240628.vhd",
 *         Owners = "system",
 *     });
 *     var @default = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = @default.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = zoneId,
 *     });
 *     var exampleSecurityGroup = new AliCloud.Ecs.SecurityGroup("example", new()
 *     {
 *         Name = name,
 *         VpcId = @default.Apply(@default => @default.Apply(getNetworksResult => getNetworksResult.Ids[0])),
 *     });
 *     var defaultInstance = new AliCloud.Ecs.Instance("default", new()
 *     {
 *         AvailabilityZone = zoneId,
 *         InstanceName = name,
 *         ImageId = exampleGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = Output.Tuple(example, example.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes).Length).Apply(values =>
 *         {
 *             var example = values.Item1;
 *             var length = values.Item2;
 *             return example.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes)[length - 1].Id;
 *         }),
 *         SecurityGroups = new[]
 *         {
 *             exampleSecurityGroup.Id,
 *         },
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         SystemDiskCategory = "cloud_essd",
 *     });
 *     var defaultInstance2 = new AliCloud.DatabaseFilesystem.Instance("default", new()
 *     {
 *         Category = "enterprise",
 *         ZoneId = defaultInstance.AvailabilityZone,
 *         PerformanceLevel = "PL1",
 *         FsName = name,
 *         Size = 100,
 *     });
 *     var exampleInstanceAttachment = new AliCloud.DatabaseFilesystem.InstanceAttachment("example", new()
 *     {
 *         EcsId = defaultInstance.Id,
 *         InstanceId = defaultInstance2.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasefilesystem"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		zoneId := "cn-hangzhou-i"
 * 		example, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone:   pulumi.StringRef(zoneId),
 * 			InstanceTypeFamily: pulumi.StringRef("ecs.g7se"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			InstanceType: pulumi.StringRef(example.InstanceTypes[len(example&#46;InstanceTypes)-1].Id),
 * 			NameRegex:    pulumi.StringRef("^aliyun_2_1903_x64_20G_alibase_20240628.vhd"),
 * 			Owners:       pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(_default.Ids[0]),
 * 			ZoneId: pulumi.StringRef(zoneId),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSecurityGroup, err := ecs.NewSecurityGroup(ctx, "example", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: pulumi.String(_default.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ecs.NewInstance(ctx, "default", &ecs.InstanceArgs{
 * 			AvailabilityZone: pulumi.String(zoneId),
 * 			InstanceName:     pulumi.String(name),
 * 			ImageId:          pulumi.String(exampleGetImages.Images[0].Id),
 * 			InstanceType:     example.InstanceTypes[len(example&#46;InstanceTypes)-1].Id,
 * 			SecurityGroups: pulumi.StringArray{
 * 				exampleSecurityGroup.ID(),
 * 			},
 * 			VswitchId:          pulumi.String(defaultGetSwitches.Ids[0]),
 * 			SystemDiskCategory: pulumi.String("cloud_essd"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance2, err := databasefilesystem.NewInstance(ctx, "default", &databasefilesystem.InstanceArgs{
 * 			Category:         pulumi.String("enterprise"),
 * 			ZoneId:           defaultInstance.AvailabilityZone,
 * 			PerformanceLevel: pulumi.String("PL1"),
 * 			FsName:           pulumi.String(name),
 * 			Size:             pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = databasefilesystem.NewInstanceAttachment(ctx, "example", &databasefilesystem.InstanceAttachmentArgs{
 * 			EcsId:      defaultInstance.ID(),
 * 			InstanceId: defaultInstance2.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.databasefilesystem.Instance;
 * import com.pulumi.alicloud.databasefilesystem.InstanceArgs;
 * import com.pulumi.alicloud.databasefilesystem.InstanceAttachment;
 * import com.pulumi.alicloud.databasefilesystem.InstanceAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var zoneId = "cn-hangzhou-i";
 *         final var example = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(zoneId)
 *             .instanceTypeFamily("ecs.g7se")
 *             .build());
 *         final var exampleGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .instanceType(example.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes())[example&#46;applyValue(getInstanceTypesResult -> getInstanceTypesResult&#46;instanceTypes())&#46;length() - 1].id())
 *             .nameRegex("^aliyun_2_1903_x64_20G_alibase_20240628.vhd")
 *             .owners("system")
 *             .build());
 *         final var default = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(default_.ids()[0])
 *             .zoneId(zoneId)
 *             .build());
 *         var exampleSecurityGroup = new SecurityGroup("exampleSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(default_.ids()[0])
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .availabilityZone(zoneId)
 *             .instanceName(name)
 *             .imageId(exampleGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(example.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes())[example&#46;applyValue(getInstanceTypesResult -> getInstanceTypesResult&#46;instanceTypes())&#46;length() - 1].id())
 *             .securityGroups(exampleSecurityGroup.id())
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .systemDiskCategory("cloud_essd")
 *             .build());
 *         var defaultInstance2 = new Instance("defaultInstance2", InstanceArgs.builder()
 *             .category("enterprise")
 *             .zoneId(defaultInstance.availabilityZone())
 *             .performanceLevel("PL1")
 *             .fsName(name)
 *             .size(100)
 *             .build());
 *         var exampleInstanceAttachment = new InstanceAttachment("exampleInstanceAttachment", InstanceAttachmentArgs.builder()
 *             .ecsId(defaultInstance.id())
 *             .instanceId(defaultInstance2.id())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DBFS Instance Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:databasefilesystem/instanceAttachment:InstanceAttachment example <instance_id>:<ecs_id>
 * ```
 * @property ecsId The ID of the ECS instance.
 * @property instanceId The ID of the database file system.
 */
public data class InstanceAttachmentArgs(
    public val ecsId: Output<String>? = null,
    public val instanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.databasefilesystem.InstanceAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.databasefilesystem.InstanceAttachmentArgs =
        com.pulumi.alicloud.databasefilesystem.InstanceAttachmentArgs.builder()
            .ecsId(ecsId?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceAttachmentArgs].
 */
@PulumiTagMarker
public class InstanceAttachmentArgsBuilder internal constructor() {
    private var ecsId: Output<String>? = null

    private var instanceId: Output<String>? = null

    /**
     * @param value The ID of the ECS instance.
     */
    @JvmName("wqxatjvybduraufn")
    public suspend fun ecsId(`value`: Output<String>) {
        this.ecsId = value
    }

    /**
     * @param value The ID of the database file system.
     */
    @JvmName("hfxmoqaarqyfidrr")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The ID of the ECS instance.
     */
    @JvmName("yuioavpwiuctwbft")
    public suspend fun ecsId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsId = mapped
    }

    /**
     * @param value The ID of the database file system.
     */
    @JvmName("ktvychvdofviktjk")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    internal fun build(): InstanceAttachmentArgs = InstanceAttachmentArgs(
        ecsId = ecsId,
        instanceId = instanceId,
    )
}
