@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceLinkedRole].
 */
@PulumiTagMarker
public class ServiceLinkedRoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceLinkedRoleArgs = ServiceLinkedRoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceLinkedRoleArgsBuilder.() -> Unit) {
        val builder = ServiceLinkedRoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceLinkedRole {
        val builtJavaResource =
            com.pulumi.alicloud.databasefilesystem.ServiceLinkedRole(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceLinkedRole(builtJavaResource)
    }
}

/**
 * Using this data source can create Dbfs service-linked roles(SLR). Dbfs may need to access another Alibaba Cloud service to implement a specific feature. In this case, Dbfs must assume a specific service-linked role, which is a Resource Access Management (RAM) role, to obtain permissions to access another Alibaba Cloud service.
 * For information about Dbfs service-linked roles(SLR) and how to use it, see [What is service-linked roles](https://www.alibabacloud.com/help/doc-detail/181425.htm).
 * > **NOTE:** Available since v1.157.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const serviceLinkedRole = new alicloud.databasefilesystem.ServiceLinkedRole("service_linked_role", {productName: "AliyunServiceRoleForDbfs"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * service_linked_role = alicloud.databasefilesystem.ServiceLinkedRole("service_linked_role", product_name="AliyunServiceRoleForDbfs")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceLinkedRole = new AliCloud.DatabaseFilesystem.ServiceLinkedRole("service_linked_role", new()
 *     {
 *         ProductName = "AliyunServiceRoleForDbfs",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasefilesystem"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databasefilesystem.NewServiceLinkedRole(ctx, "service_linked_role", &databasefilesystem.ServiceLinkedRoleArgs{
 * 			ProductName: pulumi.String("AliyunServiceRoleForDbfs"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.databasefilesystem.ServiceLinkedRole;
 * import com.pulumi.alicloud.databasefilesystem.ServiceLinkedRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceLinkedRole = new ServiceLinkedRole("serviceLinkedRole", ServiceLinkedRoleArgs.builder()
 *             .productName("AliyunServiceRoleForDbfs")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   serviceLinkedRole:
 *     type: alicloud:databasefilesystem:ServiceLinkedRole
 *     name: service_linked_role
 *     properties:
 *       productName: AliyunServiceRoleForDbfs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Dbfs service-linked roles(SLR) can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:databasefilesystem/serviceLinkedRole:ServiceLinkedRole example <product_name>
 * ```
 */
public class ServiceLinkedRole internal constructor(
    override val javaResource: com.pulumi.alicloud.databasefilesystem.ServiceLinkedRole,
) : KotlinCustomResource(javaResource, ServiceLinkedRoleMapper) {
    /**
     * The product name for SLR. Dbfs can automatically create the following service-linked roles: `AliyunServiceRoleForDbfs`.
     */
    public val productName: Output<String>
        get() = javaResource.productName().applyValue({ args0 -> args0 })

    /**
     * The status of the service Associated role. Valid Values: `true`: Created. `false`: not created.
     */
    public val status: Output<Boolean>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ServiceLinkedRoleMapper : ResourceMapper<ServiceLinkedRole> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.databasefilesystem.ServiceLinkedRole::class == javaResource::class

    override fun map(javaResource: Resource): ServiceLinkedRole = ServiceLinkedRole(
        javaResource as
            com.pulumi.alicloud.databasefilesystem.ServiceLinkedRole,
    )
}

/**
 * @see [ServiceLinkedRole].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceLinkedRole].
 */
public suspend fun serviceLinkedRole(
    name: String,
    block: suspend ServiceLinkedRoleResourceBuilder.() -> Unit,
): ServiceLinkedRole {
    val builder = ServiceLinkedRoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceLinkedRole].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceLinkedRole(name: String): ServiceLinkedRole {
    val builder = ServiceLinkedRoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
