@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin

import com.pulumi.alicloud.databasefilesystem.ServiceLinkedRoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Using this data source can create Dbfs service-linked roles(SLR). Dbfs may need to access another Alibaba Cloud service to implement a specific feature. In this case, Dbfs must assume a specific service-linked role, which is a Resource Access Management (RAM) role, to obtain permissions to access another Alibaba Cloud service.
 * For information about Dbfs service-linked roles(SLR) and how to use it, see [What is service-linked roles](https://www.alibabacloud.com/help/doc-detail/181425.htm).
 * > **NOTE:** Available since v1.157.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const serviceLinkedRole = new alicloud.databasefilesystem.ServiceLinkedRole("service_linked_role", {productName: "AliyunServiceRoleForDbfs"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * service_linked_role = alicloud.databasefilesystem.ServiceLinkedRole("service_linked_role", product_name="AliyunServiceRoleForDbfs")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceLinkedRole = new AliCloud.DatabaseFilesystem.ServiceLinkedRole("service_linked_role", new()
 *     {
 *         ProductName = "AliyunServiceRoleForDbfs",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasefilesystem"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databasefilesystem.NewServiceLinkedRole(ctx, "service_linked_role", &databasefilesystem.ServiceLinkedRoleArgs{
 * 			ProductName: pulumi.String("AliyunServiceRoleForDbfs"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.databasefilesystem.ServiceLinkedRole;
 * import com.pulumi.alicloud.databasefilesystem.ServiceLinkedRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceLinkedRole = new ServiceLinkedRole("serviceLinkedRole", ServiceLinkedRoleArgs.builder()
 *             .productName("AliyunServiceRoleForDbfs")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   serviceLinkedRole:
 *     type: alicloud:databasefilesystem:ServiceLinkedRole
 *     name: service_linked_role
 *     properties:
 *       productName: AliyunServiceRoleForDbfs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Dbfs service-linked roles(SLR) can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:databasefilesystem/serviceLinkedRole:ServiceLinkedRole example <product_name>
 * ```
 * @property productName The product name for SLR. Dbfs can automatically create the following service-linked roles: `AliyunServiceRoleForDbfs`.
 */
public data class ServiceLinkedRoleArgs(
    public val productName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.databasefilesystem.ServiceLinkedRoleArgs> {
    override fun toJava(): com.pulumi.alicloud.databasefilesystem.ServiceLinkedRoleArgs =
        com.pulumi.alicloud.databasefilesystem.ServiceLinkedRoleArgs.builder()
            .productName(productName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceLinkedRoleArgs].
 */
@PulumiTagMarker
public class ServiceLinkedRoleArgsBuilder internal constructor() {
    private var productName: Output<String>? = null

    /**
     * @param value The product name for SLR. Dbfs can automatically create the following service-linked roles: `AliyunServiceRoleForDbfs`.
     */
    @JvmName("argbvpejjohuwljk")
    public suspend fun productName(`value`: Output<String>) {
        this.productName = value
    }

    /**
     * @param value The product name for SLR. Dbfs can automatically create the following service-linked roles: `AliyunServiceRoleForDbfs`.
     */
    @JvmName("vpmuscjhvxmnoqlv")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productName = mapped
    }

    internal fun build(): ServiceLinkedRoleArgs = ServiceLinkedRoleArgs(
        productName = productName,
    )
}
