@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin.inputs

import com.pulumi.alicloud.databasefilesystem.inputs.InstanceEcsListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ecsId The ID of the ECS instance.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 */
public data class InstanceEcsListArgs(
    public val ecsId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.databasefilesystem.inputs.InstanceEcsListArgs> {
    override fun toJava(): com.pulumi.alicloud.databasefilesystem.inputs.InstanceEcsListArgs =
        com.pulumi.alicloud.databasefilesystem.inputs.InstanceEcsListArgs.builder()
            .ecsId(ecsId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceEcsListArgs].
 */
@PulumiTagMarker
public class InstanceEcsListArgsBuilder internal constructor() {
    private var ecsId: Output<String>? = null

    /**
     * @param value The ID of the ECS instance.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("xwgvmlbnbcxpgxyr")
    public suspend fun ecsId(`value`: Output<String>) {
        this.ecsId = value
    }

    /**
     * @param value The ID of the ECS instance.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("akhfrtdvvcwumrhi")
    public suspend fun ecsId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsId = mapped
    }

    internal fun build(): InstanceEcsListArgs = InstanceEcsListArgs(
        ecsId = ecsId,
    )
}
